/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.StackingModel;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GeneratePredictionModelTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PredictionModelMetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractStacking
extends OperatorChain
implements Learner {
    protected InputPort exampleSetInput = this.getInputPorts().createPort("training set", ExampleSet.class);
    protected OutputPortExtender baseInputExtender = new OutputPortExtender("training set", this.getBaseModelLearnerProcess().getInnerSources());
    protected InputPortExtender baseModelExtender = new InputPortExtender("base model", (Ports<InputPort>)this.getBaseModelLearnerProcess().getInnerSinks(), (MetaData)new PredictionModelMetaData((Class<? extends PredictionModel>)PredictionModel.class, new ExampleSetMetaData()), 2);
    protected OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public AbstractStacking(OperatorDescription description, String ... subprocessNames) {
        super(description, subprocessNames);
        this.baseInputExtender.start();
        this.baseModelExtender.start();
        this.getTransformer().addRule(this.baseInputExtender.makePassThroughRule(this.exampleSetInput));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new GeneratePredictionModelTransformationRule(this.exampleSetInput, this.modelOutput, PredictionModel.class));
    }

    protected abstract String getModelName();

    protected abstract ExecutionUnit getBaseModelLearnerProcess();

    protected abstract Model getStackingModel(ExampleSet var1) throws OperatorException;

    public abstract boolean keepOldAttributes();

    @Override
    public void doWork() throws OperatorException {
        ExampleSet input = (ExampleSet)this.exampleSetInput.getData();
        this.modelOutput.deliver(this.learn(input));
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.baseInputExtender.deliverToAll(exampleSet, false);
        this.getBaseModelLearnerProcess().execute();
        List<Model> baseModels = this.baseModelExtender.getData(true);
        ExampleSet stackingLearningSet = (ExampleSet)exampleSet.clone();
        if (!this.keepOldAttributes()) {
            stackingLearningSet.getAttributes().clearRegular();
        }
        LinkedList<Attribute> tempPredictions = new LinkedList<Attribute>();
        int i = 0;
        for (Model baseModel : baseModels) {
            exampleSet = baseModel.apply(exampleSet);
            Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
            predictedLabel.setName("base_prediction" + i);
            PredictionModel.removePredictedLabel(exampleSet, false, true);
            stackingLearningSet.getAttributes().addRegular(predictedLabel);
            tempPredictions.add(predictedLabel);
            ++i;
        }
        Model stackingModel = this.getStackingModel(stackingLearningSet);
        PredictionModel.removePredictedLabel(stackingLearningSet);
        for (Attribute tempPrediction : tempPredictions) {
            stackingLearningSet.getAttributes().remove(tempPrediction);
            stackingLearningSet.getExampleTable().removeAttribute(tempPrediction);
        }
        return new StackingModel(exampleSet, this.getModelName(), baseModels, stackingModel, this.keepOldAttributes());
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public boolean supportsCapability(OperatorCapability c) {
        return true;
    }
}

