/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.LearnerPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.PredictionModelMetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.tools.Tools;

public abstract class AbstractMetaLearner
extends OperatorChain
implements Learner {
    protected final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("training set");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private final OutputPort innerExampleSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training set");
    protected final InputPort innerModelSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("model");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public AbstractMetaLearner(OperatorDescription description) {
        super(description, "Learning Process");
        this.exampleSetInput.addPrecondition(new LearnerPrecondition(this, this.exampleSetInput));
        this.innerModelSink.addPrecondition(new SimplePrecondition(this.innerModelSink, new PredictionModelMetaData((Class<? extends PredictionModel>)PredictionModel.class, new ExampleSetMetaData())));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.innerExampleSource, true){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (unmodifiedMetaData instanceof ExampleSetMetaData) {
                    return AbstractMetaLearner.this.modifyExampleSetMetaData((ExampleSetMetaData)unmodifiedMetaData);
                }
                return unmodifiedMetaData;
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.innerModelSink, this.modelOutput, true){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (unmodifiedMetaData instanceof PredictionModelMetaData) {
                    return AbstractMetaLearner.this.modifyGeneratedModelMetaData((PredictionModelMetaData)unmodifiedMetaData);
                }
                return super.modifyMetaData(unmodifiedMetaData);
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    protected MetaData modifyGeneratedModelMetaData(PredictionModelMetaData unmodifiedMetaData) {
        return unmodifiedMetaData;
    }

    protected MetaData modifyExampleSetMetaData(ExampleSetMetaData unmodifiedMetaData) {
        return unmodifiedMetaData;
    }

    public InputPort getTrainingSetInputPort() {
        return this.exampleSetInput;
    }

    public OutputPort getModelOutputPort() {
        return this.modelOutput;
    }

    public InputPort getInnerModelSink() {
        return this.innerModelSink;
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true));
        check.checkLearnerCapabilities(this, exampleSet);
        Model model = this.learn(exampleSet);
        this.modelOutput.deliver(model);
        this.exampleSetOutput.deliver(exampleSet);
    }

    protected Model applyInnerLearner(ExampleSet exampleSet) throws OperatorException {
        this.innerExampleSource.deliver(exampleSet);
        this.executeInnerLearner();
        return (Model)this.innerModelSink.getData();
    }

    protected void executeInnerLearner() throws OperatorException {
        this.getSubprocess(0).execute();
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }
}

