/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class RelativeNeighborhood
implements Neighborhood {
    private static final long serialVersionUID = -3244742069757655400L;
    public static final String PARAMETER_RELATIVE_SIZE = "relative_size";
    private double relativeSize;

    @Override
    public <T extends Serializable> Collection<Tupel<Double, T>> getNeighbourhood(GeometricDataCollection<T> samples, double[] probePoint) {
        return samples.getNearestValueDistances(Math.max((int)((double)samples.size() * this.relativeSize), 1), probePoint);
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_RELATIVE_SIZE, "Specifies the size of the neighborhood relative to the total number of examples. A value of 0.04 would include 4% of the data points into the neighborhood.", 0.0, 1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public void init(ParameterHandler handler) throws UndefinedParameterError {
        this.relativeSize = handler.getParameterAsDouble(PARAMETER_RELATIVE_SIZE);
    }

    public String toString() {
        return "Relative neighborhood with a fraction of " + Tools.formatNumber(this.relativeSize, 3) + " of the complete data set";
    }
}

