/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.local.AtLeastNeighborhood;
import com.rapidminer.operator.learner.local.DistanceNeighborhood;
import com.rapidminer.operator.learner.local.NearestNeighborNeighborhood;
import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.operator.learner.local.RelativeNeighborhood;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.LinkedList;
import java.util.List;

public class Neighborhoods {
    public static final String PARAMETER_NEIGHBORHOOD_TYPE = "neighborhood_type";
    public static final String[] NEIGHBORHOOD_NAMES = new String[]{"Fixed Number", "Fixed Distance", "Relative Number", "Distance but at least"};
    public static final Class<?>[] NEIGHBORHOOD_CLASSES = new Class[]{NearestNeighborNeighborhood.class, DistanceNeighborhood.class, RelativeNeighborhood.class, AtLeastNeighborhood.class};

    public static final Neighborhood createNeighborhood(ParameterHandler handler) throws OperatorException {
        int chosenNeighborhood = handler.getParameterAsInt(PARAMETER_NEIGHBORHOOD_TYPE);
        try {
            Neighborhood hood = (Neighborhood)NEIGHBORHOOD_CLASSES[chosenNeighborhood].newInstance();
            hood.init(handler);
            return hood;
        }
        catch (InstantiationException e) {
            throw new OperatorException("Could not instanciate distance measure " + NEIGHBORHOOD_NAMES[chosenNeighborhood]);
        }
        catch (IllegalAccessException e) {
            throw new OperatorException("Could not instanciate distance measure " + NEIGHBORHOOD_NAMES[chosenNeighborhood]);
        }
    }

    public static final List<ParameterType> getParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_NEIGHBORHOOD_TYPE, "Determines which type of neighborhood should be used. Either with fixed number of neighbors, or all neighbors within a distance or mixed.", NEIGHBORHOOD_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        for (int i = 0; i < NEIGHBORHOOD_CLASSES.length; ++i) {
            try {
                Neighborhood hood = (Neighborhood)NEIGHBORHOOD_CLASSES[i].newInstance();
                for (ParameterType hoodType : hood.getParameterTypes(handler)) {
                    hoodType.registerDependencyCondition(new EqualTypeCondition(handler, PARAMETER_NEIGHBORHOOD_TYPE, NEIGHBORHOOD_NAMES, true, i));
                    types.add(hoodType);
                }
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return types;
    }
}

