/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NearestNeighborNeighborhood
implements Neighborhood {
    private static final long serialVersionUID = 3449482421551746223L;
    public static final String PARAMETER_K = "k";
    private int k = 1;

    @Override
    public <T extends Serializable> Collection<Tupel<Double, T>> getNeighbourhood(GeometricDataCollection<T> samples, double[] probePoint) {
        return samples.getNearestValueDistances(this.k, probePoint);
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler handler) {
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_K, "Specifies the number of neighbors in the neighborhood. Regardless of the local density, always that much samples are returned.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        return Collections.singletonList(type);
    }

    @Override
    public void init(ParameterHandler handler) throws UndefinedParameterError {
        this.k = handler.getParameterAsInt(PARAMETER_K);
    }

    public String toString() {
        return "Nearest Neighbor";
    }
}

