/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.local.LocalPolynomialRegressionModel;
import com.rapidminer.operator.learner.local.Neighborhoods;
import com.rapidminer.operator.preprocessing.weighting.LocalPolynomialExampleWeightingOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.container.LinearList;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import com.rapidminer.tools.math.smoothing.SmoothingKernels;
import java.util.List;

public class LocalPolynomialRegressionOperator
extends AbstractLearner {
    public static final String PARAMETER_DEGREE = "degree";
    public static final String PARAMETER_RIDGE = "ridge_factor";
    public static final String PARAMETER_USE_EXAMPLE_WEIGHTS = "use_weights";
    public static final String PARAMETER_USE_ROBUST_ESTIMATION = "use_robust_estimation";

    public LocalPolynomialRegressionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        DistanceMeasure measure = DistanceMeasures.createMeasure(this);
        measure.init(exampleSet);
        LinearList<LocalPolynomialRegressionModel.RegressionData> data = new LinearList<LocalPolynomialRegressionModel.RegressionData>(measure);
        boolean useWeights = this.getParameterAsBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS);
        if (this.getParameterAsBoolean(PARAMETER_USE_ROBUST_ESTIMATION)) {
            useWeights = true;
            try {
                LocalPolynomialExampleWeightingOperator weightingOperator = OperatorService.createOperator(LocalPolynomialExampleWeightingOperator.class);
                exampleSet = weightingOperator.doWork((ExampleSet)exampleSet.clone(), this);
            }
            catch (OperatorCreationException e) {
                throw new UserError((Operator)this, 904, "LocalPolynomialExampleWeighting", e.getMessage());
            }
        }
        Attributes attributes = exampleSet.getAttributes();
        Attribute label = attributes.getLabel();
        Attribute weightAttribute = attributes.getWeight();
        for (Example example : exampleSet) {
            double[] values = new double[attributes.size()];
            double labelValue = example.getValue(label);
            double weight = 1.0;
            if (weightAttribute != null && useWeights) {
                weight = example.getValue(weightAttribute);
            }
            if (!(weight > 0.0)) continue;
            int i = 0;
            for (Attribute attribute : attributes) {
                values[i] = example.getValue(attribute);
                ++i;
            }
            data.add(values, new LocalPolynomialRegressionModel.RegressionData(values, labelValue, weight));
        }
        return new LocalPolynomialRegressionModel(exampleSet, data, Neighborhoods.createNeighborhood(this), SmoothingKernels.createKernel(this), this.getParameterAsInt(PARAMETER_DEGREE), this.getParameterAsDouble(PARAMETER_RIDGE));
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NUMERICAL_ATTRIBUTES: 
            case NUMERICAL_LABEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_DEGREE, "Specifies the degree of the local fitted polynomial. Please keep in mind, that a higher degree than 2 will increase calculation time extremely and probably suffer from overfitting.", 0, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_RIDGE, "Specifies the ridge factor. This factor is used to penalize high coefficients. In order to aviod overfitting this might be increased.", 0.0, Double.POSITIVE_INFINITY, 1.0E-9);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_ROBUST_ESTIMATION, "If checked, a reweighting of the examples is performed in order to downweight outliers", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS, "Indicates if example weights should be used if present in the given example set.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_ROBUST_ESTIMATION, false, false));
        types.add(type);
        type = new ParameterTypeInt("iterations", "The number of iterations performed for weight calculation.", 1, Integer.MAX_VALUE, 20);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_ROBUST_ESTIMATION, false, true));
        types.add(type);
        types.addAll(DistanceMeasures.getParameterTypesForNumericals(this));
        types.addAll(Neighborhoods.getParameterTypes(this));
        types.addAll(SmoothingKernels.getParameterTypes(this));
        return types;
    }
}

