/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DistanceNeighborhood
implements Neighborhood {
    private static final long serialVersionUID = -4880619185491306844L;
    public static final String PARAMETER_DISTANCE = "fixed_distance";
    private double withinDistance;

    @Override
    public <T extends Serializable> Collection<Tupel<Double, T>> getNeighbourhood(GeometricDataCollection<T> samples, double[] probePoint) {
        return samples.getNearestValueDistances(this.withinDistance, probePoint);
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler handler) {
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_DISTANCE, "Specifies the size of the neighborhood. All points within this distance are added.", 0.0, Double.POSITIVE_INFINITY, 5.0);
        type.setExpert(false);
        return Collections.singletonList(type);
    }

    @Override
    public void init(ParameterHandler handler) throws UndefinedParameterError {
        this.withinDistance = handler.getParameterAsDouble(PARAMETER_DISTANCE);
    }

    public String toString() {
        return "Distance Neighborhood";
    }
}

