/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.local;

import com.rapidminer.operator.learner.local.Neighborhood;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AtLeastNeighborhood
implements Neighborhood {
    private static final long serialVersionUID = -9140050953901279562L;
    public static final String PARAMETER_AT_LEAST = "at_least";
    public static final String PARAMETER_DISTANCE = "distance";
    private double distance;
    private int minK;

    @Override
    public <T extends Serializable> Collection<Tupel<Double, T>> getNeighbourhood(GeometricDataCollection<T> samples, double[] probePoint) {
        return samples.getNearestValueDistances(this.distance, this.minK, probePoint);
    }

    @Override
    public List<ParameterType> getParameterTypes(ParameterHandler handler) {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeNumber type = new ParameterTypeDouble(PARAMETER_DISTANCE, "Specifies the size of the neighborhood. All points within this distance are added.", 0.0, Double.POSITIVE_INFINITY, 10.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_AT_LEAST, "If the neighborhood count is less than this number, the distance is increased until this number is met.", 0, Integer.MAX_VALUE, 20);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public void init(ParameterHandler handler) throws UndefinedParameterError {
        this.distance = handler.getParameterAsDouble(PARAMETER_DISTANCE);
        this.minK = handler.getParameterAsInt(PARAMETER_AT_LEAST);
    }

    public String toString() {
        return "At Least Neighborhoor";
    }
}

