/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;

public class DefaultModel
extends PredictionModel {
    private static final long serialVersionUID = -1455906287520811107L;
    private double value;
    private double[] confidences;

    public DefaultModel(ExampleSet exampleSet, double value) {
        this(exampleSet, value, null);
    }

    public DefaultModel(ExampleSet exampleSet, double value, double[] confidences) {
        super(exampleSet);
        this.value = value;
        this.confidences = confidences;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        Attribute label = this.getLabel();
        for (Example example : exampleSet) {
            example.setValue(predictedLabelAttribute, this.value);
            if (!label.isNominal()) continue;
            for (int i = 0; i < this.confidences.length; ++i) {
                example.setConfidence(predictedLabelAttribute.getMapping().mapIndex(i), this.confidences[i]);
            }
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        return super.toString() + Tools.getLineSeparator() + "default value: " + (this.getLabel().isNominal() ? this.getLabel().getMapping().mapIndex((int)this.value) : this.value + "");
    }
}

