/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.lazy.AttributeDefaultModel;
import com.rapidminer.operator.learner.lazy.DefaultModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ParameterConditionedPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DefaultLearner
extends AbstractLearner {
    public static final String PARAMETER_METHOD = "method";
    public static final String PARAMETER_CONSTANT = "constant";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private static final String[] METHODS = new String[]{"median", "average", "mode", "constant", "attribute"};
    public static final int MEDIAN = 0;
    public static final int AVERAGE = 1;
    public static final int MODE = 2;
    public static final int CONSTANT = 3;
    public static final int ATTRIBUTE = 4;

    public DefaultLearner(OperatorDescription description) {
        super(description);
        InputPort exampleIn = this.getExampleSetInputPort();
        exampleIn.addPrecondition(new ParameterConditionedPrecondition(exampleIn, new AttributeSetPrecondition(exampleIn, new AttributeSetPrecondition.AttributeNameProvider(){

            @Override
            public String[] getRequiredAttributeNames() {
                try {
                    return new String[]{DefaultLearner.this.getParameterAsString(DefaultLearner.PARAMETER_ATTRIBUTE_NAME)};
                }
                catch (UndefinedParameterError e) {
                    return new String[0];
                }
            }
        }, new String[0]), this, PARAMETER_METHOD, METHODS[4]));
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double value = 0.0;
        double[] confidences = null;
        int method = this.getParameterAsInt(PARAMETER_METHOD);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && (method == 0 || method == 1)) {
            this.logWarning("Cannot use method '" + METHODS[method] + "' for nominal labels: changing to 'mode'!");
            method = 2;
        } else if (!label.isNominal() && method == 2) {
            this.logWarning("Cannot use method '" + METHODS[method] + "' for numerical labels: changing to 'average'!");
            method = 1;
        }
        switch (method) {
            case 0: {
                double[] labels = new double[exampleSet.size()];
                Iterator r = exampleSet.iterator();
                int counter = 0;
                while (r.hasNext()) {
                    Example example = (Example)r.next();
                    labels[counter++] = example.getValue(example.getAttributes().getLabel());
                }
                Arrays.sort(labels);
                value = labels[exampleSet.size() / 2];
                break;
            }
            case 1: {
                exampleSet.recalculateAttributeStatistics(label);
                value = exampleSet.getStatistics(label, "average");
                break;
            }
            case 2: {
                exampleSet.recalculateAttributeStatistics(label);
                value = exampleSet.getStatistics(label, "mode");
                confidences = new double[label.getMapping().size()];
                for (int i = 0; i < confidences.length; ++i) {
                    confidences[i] = exampleSet.getStatistics(label, "count", label.getMapping().mapIndex(i)) / (double)exampleSet.size();
                }
                break;
            }
            case 3: {
                value = this.getParameterAsDouble(PARAMETER_CONSTANT);
                break;
            }
            case 4: {
                return new AttributeDefaultModel(exampleSet, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
            }
            default: {
                throw new OperatorException("DefaultLearner: Unknown default method '" + method + "'!");
            }
        }
        this.log("Default value is '" + (label.isNominal() ? label.getMapping().mapIndex((int)value) : value + "") + "'.");
        return new DefaultModel(exampleSet, value, confidences);
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return DefaultModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case ONE_CLASS_LABEL: 
            case NUMERICAL_LABEL: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_METHOD, "The method to compute the default.", METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_CONSTANT, "Value returned when method = constant.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_METHOD, METHODS, true, 3));
        types.add(type);
        type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute to get the predicted value from.", this.getExampleSetInputPort(), true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_METHOD, METHODS, false, 4));
        types.add(type);
        return types;
    }
}

