/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;

public class AttributeDefaultModel
extends PredictionModel {
    private static final long serialVersionUID = 3987661566241516287L;
    private String sourceAttributeName;

    protected AttributeDefaultModel(ExampleSet trainingExampleSet, String sourceAttribute) {
        super(trainingExampleSet);
        this.sourceAttributeName = sourceAttribute;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        Attribute label = this.getLabel();
        Attribute sourceAttribute = exampleSet.getAttributes().get(this.sourceAttributeName);
        if (sourceAttribute != null) {
            if (label.isNominal() && !sourceAttribute.isNominal()) {
                throw new UserError(null, 120, this.sourceAttributeName, "numerical", "nominal");
            }
            if (!label.isNominal() && sourceAttribute.isNominal()) {
                throw new UserError(null, 120, this.sourceAttributeName, "nominal", "numerical");
            }
            for (Example example : exampleSet) {
                String classValue = example.getValueAsString(sourceAttribute);
                example.setValue(predictedLabel, classValue);
                if (!label.isNominal()) continue;
                example.setConfidence(classValue, 1.0);
            }
        } else {
            throw new UserError(null, 111, this.sourceAttributeName);
        }
        return exampleSet;
    }
}

