/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.utility;

import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.utility.Utility;

public abstract class AbstractUtility
implements Utility {
    protected double[] priors;
    protected int large;

    public AbstractUtility(double[] priors, int large) {
        this.priors = new double[priors.length];
        System.arraycopy(priors, 0, this.priors, 0, 2);
        this.large = large;
    }

    @Override
    public double calculateM(double delta, double epsilon) {
        double i = 1.0;
        while (this.conf(i, delta) > epsilon / 2.0) {
            i += 10000.0;
        }
        if (i > 1.0) {
            i -= 10000.0;
        }
        while (this.conf(i, delta) > epsilon / 2.0) {
            i += 1.0;
        }
        return Math.ceil(i);
    }

    @Override
    public double confidenceIntervall(double totalWeight, double delta) {
        if (totalWeight < (double)this.large) {
            return this.confSmallM(totalWeight, delta);
        }
        return this.conf(totalWeight, delta);
    }

    @Override
    public double confidenceIntervall(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        if (hypo.getCoveredWeight() < (double)this.large) {
            return this.confSmallM(totalWeight, delta);
        }
        return this.conf(totalWeight, totalPositiveWeight, hypo, delta);
    }

    public abstract double confSmallM(double var1, double var3);

    public abstract double conf(double var1, double var3);

    public abstract double conf(double var1, double var3, Hypothesis var5, double var6);

    public double inverseNormal(double p) {
        double[] a = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
        double[] b = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
        double[] c = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
        double[] d = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
        double plow = 0.02425;
        double phigh = 1.0 - plow;
        if (p < plow) {
            double q = Math.sqrt(-2.0 * Math.log(p));
            return (((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0);
        }
        if (phigh < p) {
            double q = Math.sqrt(-2.0 * Math.log(1.0 - p));
            return -(((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0);
        }
        double q = p - 0.5;
        double r = q * q;
        return (((((a[0] * r + a[1]) * r + a[2]) * r + a[3]) * r + a[4]) * r + a[5]) * q / (((((b[0] * r + b[1]) * r + b[2]) * r + b[3]) * r + b[4]) * r + 1.0);
    }
}

