/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.hypothesis.Literal;
import java.util.Arrays;
import java.util.LinkedList;

public class Rule
extends Hypothesis {
    private static final long serialVersionUID = -1121263970366784202L;
    private Literal[][] allLiterals;
    private Literal[] literals;
    private int prediction;

    public Rule(Attribute[] regularAttributes, Attribute label, boolean rejectionSampling, boolean createAll) {
        super(regularAttributes, label, rejectionSampling, createAll);
        this.allLiterals = new Literal[regularAttributes.length][];
        for (int attributeIndex = 0; attributeIndex < regularAttributes.length; ++attributeIndex) {
            this.allLiterals[attributeIndex] = new Literal[regularAttributes[attributeIndex].getMapping().size()];
            for (int valueIndex = 0; valueIndex < regularAttributes[attributeIndex].getMapping().size(); ++valueIndex) {
                this.allLiterals[attributeIndex][valueIndex] = new Literal(regularAttributes[attributeIndex], valueIndex, attributeIndex);
            }
        }
    }

    @Override
    public Hypothesis clone() {
        Rule clone = new Rule(this.literals, this.prediction);
        clone.setCoveredWeight(this.getCoveredWeight());
        clone.setPositiveWeight(this.getPositiveWeight());
        return clone;
    }

    public Rule(Literal literal, int prediction) {
        this.literals = new Literal[1];
        this.literals[0] = literal;
        this.prediction = prediction;
    }

    public Rule(Literal[] literals, int prediction) {
        this.literals = new Literal[literals.length];
        for (int i = 0; i < literals.length; ++i) {
            this.literals[i] = literals[i];
        }
        this.prediction = prediction;
    }

    @Override
    public void apply(Example e) {
        if (this.applicable(e)) {
            if (this.rejectionSampling) {
                this.coveredWeight += 1.0;
                if ((int)e.getLabel() == this.prediction) {
                    this.positiveWeight += 1.0;
                }
            } else {
                this.coveredWeight += e.getWeight();
                if ((int)e.getLabel() == this.prediction) {
                    this.positiveWeight += e.getWeight();
                }
            }
        }
    }

    @Override
    public boolean applicable(Example e) {
        boolean success = true;
        for (int i = 0; i < this.literals.length; ++i) {
            int ruleValue;
            int exampleValue = (int)e.getValue(this.literals[i].getAttribute());
            if (exampleValue == (ruleValue = this.literals[i].getValue())) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public LinkedList<Hypothesis> init(int minComplexity) {
        LinkedList<Hypothesis> border = new LinkedList<Hypothesis>();
        LinkedList<Hypothesis> result = new LinkedList<Hypothesis>();
        for (int attributeIndex = 0; attributeIndex < this.allLiterals.length; ++attributeIndex) {
            for (int valueIndex = 0; valueIndex < this.allLiterals[attributeIndex].length; ++valueIndex) {
                border.addLast(new Rule(this.allLiterals[attributeIndex][valueIndex], 1));
            }
        }
        while (!border.isEmpty()) {
            Rule rule = (Rule)border.removeFirst();
            result.addLast(rule);
            if (this.createAllHypothesis) {
                result.addLast(new Rule(rule.getLiterals(), 0));
            }
            if (rule.getComplexity() >= minComplexity) continue;
            border.addAll(rule.refine());
        }
        return result;
    }

    @Override
    public LinkedList<Hypothesis> refine() {
        LinkedList<Hypothesis> result = new LinkedList<Hypothesis>();
        Literal[] lits = new Literal[this.literals.length + 1];
        for (int i = 0; i < this.literals.length; ++i) {
            lits[i] = this.literals[i];
        }
        int lastLiteralIndex = this.literals[this.literals.length - 1].getIndex();
        for (int literalIndex = lastLiteralIndex + 1; literalIndex < this.allLiterals.length; ++literalIndex) {
            for (int valueIndex = 0; valueIndex < this.allLiterals[literalIndex].length; ++valueIndex) {
                lits[lits.length - 1] = this.allLiterals[literalIndex][valueIndex];
                result.addLast(new Rule(lits, this.prediction));
            }
        }
        return result;
    }

    @Override
    public boolean canBeRefined() {
        return this.literals[this.literals.length - 1].getIndex() != this.allLiterals.length - 1;
    }

    @Override
    public int getPrediction() {
        return this.prediction;
    }

    @Override
    public int getComplexity() {
        return this.literals.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule otherRule = (Rule)o;
        if (otherRule.literals.length != this.literals.length) {
            return false;
        }
        if (otherRule.prediction != this.prediction) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.literals.length; ++i) {
            if (this.literals[i].equals(otherRule.literals[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.literals) ^ Integer.valueOf(this.prediction).hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("IF ");
        for (int i = 0; i < this.literals.length - 1; ++i) {
            result.append(this.literals[i].toString() + " AND ");
        }
        result.append(this.literals[this.literals.length - 1].toString());
        result.append(" THEN (" + this.getLabel().getName() + "=" + this.getLabel().getMapping().mapIndex(this.getPrediction()) + ")");
        return result.toString();
    }

    public Literal[] getLiterals() {
        return this.literals;
    }
}

