/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import java.io.Serializable;
import java.util.LinkedList;

public abstract class Hypothesis
implements Serializable {
    private static final long serialVersionUID = 2081084133296284530L;
    public static final String[] HYPOTHESIS_SPACE_TYPES = new String[]{"rule"};
    public static final int FIRST_TYPE_INDEX = 0;
    public static final int TYPE_RULE = 0;
    public static final int LAST_TYPE_INDEX = 0;
    public static final int POSITIVE_CLASS = 1;
    public static final int NEGATIVE_CLASS = 0;
    private Attribute label;
    protected boolean rejectionSampling;
    protected double coveredWeight;
    protected double positiveWeight;
    protected boolean createAllHypothesis;

    public Hypothesis(Attribute[] regulars, Attribute l, boolean rs, boolean createAll) {
        this.rejectionSampling = rs;
        this.createAllHypothesis = createAll;
        this.label = l;
    }

    public Hypothesis() {
        this.coveredWeight = 0.0;
        this.positiveWeight = 0.0;
    }

    public abstract Hypothesis clone();

    public abstract int getPrediction();

    public Attribute getLabel() {
        return this.label;
    }

    public void reset() {
        this.coveredWeight = 0.0;
        this.positiveWeight = 0.0;
    }

    public double getCoveredWeight() {
        return this.coveredWeight;
    }

    public void setCoveredWeight(double value) {
        this.coveredWeight = value;
    }

    public double getPositiveWeight() {
        return this.positiveWeight;
    }

    public void setPositiveWeight(double value) {
        this.positiveWeight = value;
    }

    public abstract void apply(Example var1);

    public abstract boolean applicable(Example var1);

    public abstract LinkedList<Hypothesis> refine();

    public abstract boolean canBeRefined();

    public abstract LinkedList<Hypothesis> init(int var1);

    public abstract int getComplexity();
}

