/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.igss.Result;
import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;

public class IGSSResult
extends ResultObjectAdapter {
    private static final long serialVersionUID = -3021620651938759878L;
    private LinkedList<Result> results;
    private double[] priors;

    public IGSSResult(ExampleSet eSet) {
        this.priors = IGSSResult.getPriors(eSet);
        this.results = new LinkedList();
    }

    public void addResult(Result r) {
        this.results.addLast(r);
    }

    public LinkedList<Result> getResults() {
        return this.results;
    }

    public double[] getPriors() {
        return this.priors;
    }

    public static double[] getPriors(ExampleSet exampleSet) {
        Iterator reader = exampleSet.iterator();
        double totalWeight = 0.0;
        double totalPositiveWeight = 0.0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            totalWeight += e.getWeight();
            if ((int)e.getLabel() != 1) continue;
            totalPositiveWeight += e.getWeight();
        }
        double[] result = new double[2];
        result[1] = totalPositiveWeight / totalWeight;
        result[0] = 1.0 - result[1];
        return result;
    }

    public static double calculateDiversity(ExampleSet exampleSet, LinkedList theResults) {
        Iterator reader = exampleSet.iterator();
        int[][] predictionMatrix = new int[exampleSet.size()][2];
        int i = 0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            Iterator it = theResults.iterator();
            while (it.hasNext()) {
                Hypothesis hypo = ((Result)it.next()).getHypothesis();
                if (hypo.applicable(e)) {
                    int[] nArray = predictionMatrix[i];
                    int n = hypo.getPrediction();
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = predictionMatrix[i];
                int n = 1 - hypo.getPrediction();
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
        double sum1 = 0.0;
        for (int i2 = 0; i2 < predictionMatrix.length; ++i2) {
            if (predictionMatrix[i2][0] == 0 || predictionMatrix[i2][1] == 0) continue;
            double p0 = (double)predictionMatrix[i2][0] / (double)theResults.size();
            double p1 = (double)predictionMatrix[i2][1] / (double)theResults.size();
            sum1 = sum1 + -1.0 * p0 * IGSSResult.log2(p0) + -1.0 * p1 * IGSSResult.log2(p1);
        }
        double result = sum1 / (double)predictionMatrix.length;
        return result;
    }

    public String toString() {
        LinkedList<Result> includedResultsForDiversityCalculation = new LinkedList<Result>();
        StringBuffer result = new StringBuffer("(Rule, Utility)" + Tools.getLineSeparator());
        Iterator it = this.results.iterator();
        double cumulativeWeight = 0.0;
        int i = 1;
        while (it.hasNext()) {
            result.append(i + ") ");
            Result r = (Result)it.next();
            includedResultsForDiversityCalculation.addLast(r);
            cumulativeWeight += r.getTotalWeight();
            result.append(r.getHypothesis().toString() + ", " + r.getUtility() + Tools.getLineSeparator());
            ++i;
        }
        result.append("total necessary example weight: " + cumulativeWeight + Tools.getLineSeparator());
        result.append("a priori probability: " + this.priors[1] + Tools.getLineSeparator());
        return result.toString();
    }

    public static double log2(double arg) {
        return Math.log(arg) / Math.log(2.0);
    }

    public String getExtension() {
        return "gss";
    }

    public String getFileDescription() {
        return "IGSS results";
    }
}

