/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.encog.matrix.Matrix;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.Layer;

public class SimpleNeuralNetModel
extends PredictionModel {
    private static final long serialVersionUID = 332041465701627316L;
    private BasicNetwork network;
    private String[] attributeNames;
    private double[] attributeMin;
    private double[] attributeMax;
    private double labelMin;
    private double labelMax;

    protected SimpleNeuralNetModel(ExampleSet trainingExampleSet, BasicNetwork network, double[] attributeMin, double[] attributeMax, double labelMin, double labelMax) {
        super(trainingExampleSet);
        this.network = network;
        this.attributeNames = Tools.getRegularAttributeNames(trainingExampleSet);
        this.attributeMin = attributeMin;
        this.attributeMax = attributeMax;
        this.labelMin = labelMin;
        this.labelMax = labelMax;
    }

    public BasicNetwork getNeuralNet() {
        return this.network;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        for (Example example : exampleSet) {
            double[] data = new double[this.attributeNames.length];
            for (int i = 0; i < this.attributeNames.length; ++i) {
                data[i] = this.attributeMin[i] != this.attributeMax[i] ? (example.getValue(exampleSet.getAttributes().get(this.attributeNames[i])) - this.attributeMin[i]) / (this.attributeMax[i] - this.attributeMin[i]) : example.getValue(exampleSet.getAttributes().get(this.attributeNames[i])) - this.attributeMin[i];
            }
            BasicNeuralData neuralData = new BasicNeuralData(data);
            double prediction = this.network.compute((NeuralData)neuralData).getData(0);
            if (predictedLabel.isNominal()) {
                double scaled = (prediction - 0.5) * 2.0;
                int index = scaled > 0.0 ? predictedLabel.getMapping().getPositiveIndex() : predictedLabel.getMapping().getNegativeIndex();
                example.setValue(predictedLabel, index);
                example.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-scaled)));
                example.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(scaled)));
                continue;
            }
            example.setValue(predictedLabel, prediction * (this.labelMax - this.labelMin) + this.labelMin);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        List layers = this.network.getLayers();
        Iterator i = layers.iterator();
        int layerIndex = 0;
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            String nodeString = layer.getNeuronCount() == 1 ? "1 node" : layer.getNeuronCount() + " nodes";
            String titleString = "Layer " + (layerIndex + 1) + " (" + nodeString + ")";
            result.append(titleString + com.rapidminer.tools.Tools.getLineSeparator());
            for (int t = 0; t < titleString.length(); ++t) {
                result.append("-");
            }
            result.append(com.rapidminer.tools.Tools.getLineSeparator());
            if (layerIndex == 0) {
                result.append(Arrays.asList(this.attributeNames).toString() + com.rapidminer.tools.Tools.getLineSeparators(2));
                if (layer.hasMatrix()) {
                    this.layerWeightsToString(result, layer.getMatrix(), layerIndex);
                }
            } else if (layer.hasMatrix()) {
                this.layerWeightsToString(result, layer.getMatrix(), layerIndex);
            }
            result.append(com.rapidminer.tools.Tools.getLineSeparator());
            ++layerIndex;
        }
        return result.toString();
    }

    private void layerWeightsToString(StringBuffer result, Matrix matrix, int currentLayerIndex) {
        result.append("Output Weights:" + com.rapidminer.tools.Tools.getLineSeparator());
        int rows = matrix.getRows();
        int cols = matrix.getCols();
        for (int c = 0; c < cols; ++c) {
            result.append(com.rapidminer.tools.Tools.getLineSeparator() + "* To Layer " + (currentLayerIndex + 2) + " - Node " + (c + 1) + ":" + com.rapidminer.tools.Tools.getLineSeparator());
            for (int r = 0; r < rows - 1; ++r) {
                result.append("From Node " + (r + 1) + ": ");
                result.append(matrix.get(r, c));
                result.append(com.rapidminer.tools.Tools.getLineSeparator());
            }
            result.append("From Threshold Node: ");
            result.append(matrix.get(rows - 1, c));
            result.append(com.rapidminer.tools.Tools.getLineSeparator());
        }
    }
}

