/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.ActivationFunction;
import com.rapidminer.operator.learner.functions.neuralnet.InnerNode;
import com.rapidminer.operator.learner.functions.neuralnet.Node;

public class SigmoidFunction
extends ActivationFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "Sigmoid";
    }

    @Override
    public double calculateValue(InnerNode node, Example example) {
        Node[] inputs = node.getInputNodes();
        double[] weights = node.getWeights();
        double weightedSum = weights[0];
        for (int i = 0; i < inputs.length; ++i) {
            weightedSum += inputs[i].calculateValue(true, example) * weights[i + 1];
        }
        double result = 0.0;
        result = weightedSum < -45.0 ? 0.0 : (weightedSum > 45.0 ? 1.0 : 1.0 / (1.0 + Math.exp(-1.0 * weightedSum)));
        return result;
    }

    @Override
    public double calculateError(InnerNode node, Example example) {
        Node[] outputs = node.getOutputNodes();
        int[] numberOfOutputs = node.getOutputNodeInputIndices();
        double errorSum = 0.0;
        for (int i = 0; i < outputs.length; ++i) {
            errorSum += outputs[i].calculateError(true, example) * outputs[i].getWeight(numberOfOutputs[i]);
        }
        double value = node.calculateValue(false, example);
        return errorSum * value * (1.0 - value);
    }
}

