/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.Node;

public class OutputNode
extends Node {
    private static final long serialVersionUID = 23423534L;
    private Attribute label;
    private int classIndex = 0;
    private double labelRange;
    private double labelBase;

    public OutputNode(String nodeName, Attribute label, double labelRange, double labelBase) {
        super(nodeName, -2, -2);
        this.label = label;
        this.labelRange = labelRange;
        this.labelBase = labelBase;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public double calculateValue(boolean shouldCalculate, Example example) {
        if (Double.isNaN(this.currentValue) && shouldCalculate) {
            this.currentValue = 0.0;
            for (int i = 0; i < this.inputNodes.length; ++i) {
                this.currentValue += this.inputNodes[i].calculateValue(true, example);
            }
            if (!this.label.isNominal()) {
                this.currentValue = this.currentValue * this.labelRange + this.labelBase;
            }
        }
        return this.currentValue;
    }

    @Override
    public double calculateError(boolean shouldCalculate, Example example) {
        if (!Double.isNaN(this.currentValue) && Double.isNaN(this.currentError) && shouldCalculate) {
            if (this.label.isNominal()) {
                this.currentError = (int)example.getValue(this.label) == this.classIndex ? 1.0 - this.currentValue : 0.0 - this.currentValue;
            } else if (!this.label.isNominal()) {
                this.currentError = this.labelRange == 0.0 ? 0.0 : (example.getValue(this.label) - this.currentValue) / this.labelRange;
            }
        }
        return this.currentError;
    }
}

