/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Example;
import java.io.Serializable;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -4888796462060891114L;
    public static final int INPUT = -1;
    public static final int HIDDEN = 0;
    public static final int OUTPUT = -2;
    private int layerIndex;
    private String nodeName;
    private int nodeType;
    private boolean weightsAreUpdated = false;
    protected Node[] inputNodes = new Node[0];
    protected Node[] outputNodes = new Node[0];
    protected int[] inputNodeOutputIndices = new int[0];
    protected int[] outputNodeInputIndices = new int[0];
    protected double currentValue = Double.NaN;
    protected double currentError = Double.NaN;

    public Node(String nodeName, int layerIndex, int nodeType) {
        this.layerIndex = layerIndex;
        this.nodeName = nodeName;
        this.nodeType = nodeType;
    }

    public abstract double calculateValue(boolean var1, Example var2);

    public abstract double calculateError(boolean var1, Example var2);

    public double getWeight(int n) {
        return 1.0;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void update(Example example, double learningRate, double momentum) {
        if (!this.weightsAreUpdated) {
            for (int i = 0; i < this.inputNodes.length; ++i) {
                this.inputNodes[i].update(example, learningRate, momentum);
            }
            this.weightsAreUpdated = true;
        }
    }

    public boolean areWeightsUpdated() {
        return this.weightsAreUpdated;
    }

    public void reset() {
        if (!Double.isNaN(this.currentValue) || !Double.isNaN(this.currentError)) {
            this.weightsAreUpdated = false;
            this.currentValue = Double.NaN;
            this.currentError = Double.NaN;
            for (int i = 0; i < this.inputNodes.length; ++i) {
                this.inputNodes[i].reset();
            }
        }
    }

    public Node[] getInputNodes() {
        return this.inputNodes;
    }

    public Node[] getOutputNodes() {
        return this.outputNodes;
    }

    public int[] getInputNodeOutputIndices() {
        return this.inputNodeOutputIndices;
    }

    public int[] getOutputNodeInputIndices() {
        return this.outputNodeInputIndices;
    }

    protected boolean connectInput(Node inputNode, int inputNodeOutputIndex) {
        Node[] newInputNodes = new Node[this.inputNodes.length + 1];
        System.arraycopy(this.inputNodes, 0, newInputNodes, 0, this.inputNodes.length);
        newInputNodes[newInputNodes.length - 1] = inputNode;
        this.inputNodes = newInputNodes;
        int[] newInputNodeOutputIndices = new int[this.inputNodeOutputIndices.length + 1];
        System.arraycopy(this.inputNodeOutputIndices, 0, newInputNodeOutputIndices, 0, this.inputNodeOutputIndices.length);
        newInputNodeOutputIndices[newInputNodeOutputIndices.length - 1] = inputNodeOutputIndex;
        this.inputNodeOutputIndices = newInputNodeOutputIndices;
        return true;
    }

    protected boolean connectOutput(Node outputNode, int outputNodeInputIndex) {
        Node[] newOutputNodes = new Node[this.outputNodes.length + 1];
        System.arraycopy(this.outputNodes, 0, newOutputNodes, 0, this.outputNodes.length);
        newOutputNodes[newOutputNodes.length - 1] = outputNode;
        this.outputNodes = newOutputNodes;
        int[] newOutputNodeInputIndices = new int[this.outputNodeInputIndices.length + 1];
        System.arraycopy(this.outputNodeInputIndices, 0, newOutputNodeInputIndices, 0, this.outputNodeInputIndices.length);
        newOutputNodeInputIndices[newOutputNodeInputIndices.length - 1] = outputNodeInputIndex;
        this.outputNodeInputIndices = newOutputNodeInputIndices;
        return true;
    }

    protected boolean disconnectInput(Node inputNode, int inputNodeOutputIndex) {
        int deleteIndex = -1;
        boolean removed = false;
        int numberOfInputs = this.inputNodes.length;
        do {
            int i;
            deleteIndex = -1;
            for (i = 0; i < this.inputNodes.length; ++i) {
                if (inputNode != this.inputNodes[i] || inputNodeOutputIndex != -1 && inputNodeOutputIndex != this.inputNodeOutputIndices[i]) continue;
                deleteIndex = i;
                break;
            }
            if (deleteIndex < 0) continue;
            for (i = deleteIndex + 1; i < numberOfInputs; ++i) {
                this.inputNodes[i - 1] = this.inputNodes[i];
                this.inputNodeOutputIndices[i - 1] = this.inputNodeOutputIndices[i];
                this.inputNodes[i - 1].outputNodeInputIndices[this.inputNodeOutputIndices[i - 1]] = i - 1;
            }
            --numberOfInputs;
            removed = true;
        } while (inputNodeOutputIndex == -1 && deleteIndex != -1);
        Node[] newInputNodes = new Node[numberOfInputs];
        System.arraycopy(this.inputNodes, 0, newInputNodes, 0, numberOfInputs);
        this.inputNodes = newInputNodes;
        int[] newInputNodeOutputIndices = new int[numberOfInputs];
        System.arraycopy(this.inputNodeOutputIndices, 0, newInputNodeOutputIndices, 0, numberOfInputs);
        this.inputNodeOutputIndices = newInputNodeOutputIndices;
        return removed;
    }

    protected boolean disconnectOutput(Node outputNode, int outputNodeInputIndex) {
        int deleteIndex = -1;
        boolean removed = false;
        int numberOfOutputs = this.outputNodes.length;
        do {
            int i;
            deleteIndex = -1;
            for (i = 0; i < this.outputNodes.length; ++i) {
                if (outputNode != this.outputNodes[i] || outputNodeInputIndex != -1 && outputNodeInputIndex != this.outputNodeInputIndices[i]) continue;
                deleteIndex = i;
                break;
            }
            if (deleteIndex < 0) continue;
            for (i = deleteIndex + 1; i < numberOfOutputs; ++i) {
                this.outputNodes[i - 1] = this.outputNodes[i];
                this.outputNodeInputIndices[i - 1] = this.outputNodeInputIndices[i];
                this.outputNodes[i - 1].inputNodeOutputIndices[this.outputNodeInputIndices[i - 1]] = i - 1;
            }
            --numberOfOutputs;
            removed = true;
        } while (outputNodeInputIndex == -1 && deleteIndex != -1);
        Node[] newOutputNodes = new Node[numberOfOutputs];
        System.arraycopy(this.outputNodes, 0, newOutputNodes, 0, numberOfOutputs);
        this.outputNodes = newOutputNodes;
        int[] newOutputNodeInputIndices = new int[numberOfOutputs];
        System.arraycopy(this.outputNodeInputIndices, 0, newOutputNodeInputIndices, 0, numberOfOutputs);
        this.outputNodeInputIndices = newOutputNodeInputIndices;
        return removed;
    }

    public static boolean connect(Node firstNode, Node secondNode) {
        Node.disconnect(firstNode, secondNode);
        if (!firstNode.connectOutput(secondNode, secondNode.inputNodes.length)) {
            return false;
        }
        if (!secondNode.connectInput(firstNode, firstNode.outputNodes.length - 1)) {
            firstNode.disconnectOutput(secondNode, secondNode.inputNodes.length);
            return false;
        }
        return true;
    }

    public static boolean disconnect(Node firstNode, Node secondNode) {
        return firstNode.disconnectOutput(secondNode, -1) && secondNode.disconnectInput(firstNode, -1);
    }
}

