/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.ActivationFunction;
import com.rapidminer.operator.learner.functions.neuralnet.Node;
import com.rapidminer.tools.RandomGenerator;

public class InnerNode
extends Node {
    private static final long serialVersionUID = 8187951447455119892L;
    private double[] weights;
    private double[] weightChanges;
    private RandomGenerator randomGenerator;
    private ActivationFunction function;

    public InnerNode(String nodeName, int layerIndex, RandomGenerator randomGenerator, ActivationFunction function) {
        super(nodeName, layerIndex, 0);
        this.randomGenerator = randomGenerator;
        this.function = function;
        this.weights = new double[]{this.randomGenerator.nextDouble() * 0.1 - 0.05};
        this.weightChanges = new double[]{0.0};
    }

    public void setActivationFunction(ActivationFunction function) {
        this.function = function;
    }

    public ActivationFunction getActivationFunction() {
        return this.function;
    }

    @Override
    public double calculateValue(boolean shouldCalculate, Example example) {
        if (Double.isNaN(this.currentValue) && shouldCalculate) {
            this.currentValue = this.function.calculateValue(this, example);
        }
        return this.currentValue;
    }

    @Override
    public double calculateError(boolean shouldCalculate, Example example) {
        if (!Double.isNaN(this.currentValue) && Double.isNaN(this.currentError) && shouldCalculate) {
            this.currentError = this.function.calculateError(this, example);
        }
        return this.currentError;
    }

    @Override
    public double getWeight(int n) {
        return this.weights[n + 1];
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double[] getWeightChanges() {
        return this.weightChanges;
    }

    public void setWeightChanges(double[] weightChanges) {
        this.weightChanges = weightChanges;
    }

    @Override
    public void update(Example example, double learningRate, double momentum) {
        if (!this.areWeightsUpdated() && !Double.isNaN(this.currentError)) {
            this.function.update(this, example, learningRate, momentum);
            super.update(example, learningRate, momentum);
        }
    }

    @Override
    protected boolean connectInput(Node i, int n) {
        if (!super.connectInput(i, n)) {
            return false;
        }
        double[] newWeights = new double[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
        newWeights[newWeights.length - 1] = this.randomGenerator.nextDouble() * 0.1 - 0.05;
        this.weights = newWeights;
        double[] newWeightChanges = new double[this.weightChanges.length + 1];
        System.arraycopy(this.weightChanges, 0, newWeightChanges, 0, this.weightChanges.length);
        newWeightChanges[newWeightChanges.length - 1] = 0.0;
        this.weightChanges = newWeightChanges;
        return true;
    }

    @Override
    protected boolean disconnectInput(Node inputNode, int inputNodeOutputIndex) {
        int deleteIndex = -1;
        boolean removed = false;
        int numberOfInputs = this.inputNodes.length;
        do {
            int i;
            deleteIndex = -1;
            for (i = 0; i < this.inputNodes.length; ++i) {
                if (inputNode != this.inputNodes[i] || inputNodeOutputIndex != -1 && inputNodeOutputIndex != this.inputNodeOutputIndices[i]) continue;
                deleteIndex = i;
                break;
            }
            if (deleteIndex < 0) continue;
            for (i = deleteIndex + 1; i < this.inputNodes.length; ++i) {
                this.inputNodes[i - 1] = this.inputNodes[i];
                this.inputNodeOutputIndices[i - 1] = this.inputNodeOutputIndices[i];
                this.weights[i] = this.weights[i + 1];
                this.weightChanges[i] = this.weightChanges[i + 1];
                this.inputNodes[i - 1].outputNodeInputIndices[this.inputNodeOutputIndices[i - 1]] = i - 1;
            }
            --numberOfInputs;
            removed = true;
        } while (inputNodeOutputIndex == -1 && deleteIndex != -1);
        Node[] newInputNodes = new Node[numberOfInputs];
        System.arraycopy(this.inputNodes, 0, newInputNodes, 0, numberOfInputs);
        this.inputNodes = newInputNodes;
        int[] newInputNodeOutputIndices = new int[numberOfInputs];
        System.arraycopy(this.inputNodeOutputIndices, 0, newInputNodeOutputIndices, 0, numberOfInputs);
        this.inputNodeOutputIndices = newInputNodeOutputIndices;
        double[] newWeights = new double[numberOfInputs + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, numberOfInputs + 1);
        this.weights = newWeights;
        double[] newWeightChanges = new double[numberOfInputs + 1];
        System.arraycopy(this.weightChanges, 0, newWeightChanges, 0, numberOfInputs + 1);
        this.weightChanges = newWeightChanges;
        return removed;
    }
}

