/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.functions.neuralnet.InnerNode;
import com.rapidminer.operator.learner.functions.neuralnet.Node;
import java.io.Serializable;

public abstract class ActivationFunction
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract String getTypeName();

    public abstract double calculateValue(InnerNode var1, Example var2);

    public abstract double calculateError(InnerNode var1, Example var2);

    public void update(InnerNode node, Example example, double learningRate, double momentum) {
        Node[] inputs = node.getInputNodes();
        double[] weights = node.getWeights();
        double[] weightChanges = node.getWeightChanges();
        double delta = learningRate * node.calculateError(false, example);
        double thresholdChange = delta + momentum * weightChanges[0];
        weights[0] = weights[0] + thresholdChange;
        weightChanges[0] = thresholdChange;
        for (int i = 1; i < inputs.length + 1; ++i) {
            double currentChange = delta * inputs[i - 1].calculateValue(false, example);
            int n = i;
            weights[n] = weights[n] + (currentChange += momentum * weightChanges[i]);
            weightChanges[i] = currentChange;
        }
        node.setWeights(weights);
        node.setWeightChanges(weightChanges);
    }
}

