/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelRadial;

public class KernelPoly
extends KernelRadial {
    private static final long serialVersionUID = -118526840262643388L;
    protected double degree = 2.0;
    protected double bias = 0.0;

    public KernelPoly() {
    }

    public KernelPoly(double lengthScale, double bias, double degree) {
        super(lengthScale);
        this.bias = bias;
        this.degree = degree;
    }

    @Override
    public double eval(double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += x[i] * y[i];
        }
        result = Math.pow(Math.pow(this.lengthScale, -2.0) * result + this.bias, this.degree);
        return result;
    }

    @Override
    public String toString() {
        return "poly kernel [lengthScale = " + this.lengthScale + ", bias = " + this.bias + ", order = " + this.degree + "]";
    }
}

