/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.Kernel;

public class KernelGaussianCombination
extends Kernel {
    private static final long serialVersionUID = -8071778790596969872L;
    private double sigma1 = 1.0;
    private double sigma2 = 0.0;
    private double sigma3 = 2.0;

    public KernelGaussianCombination(double sigma1, double sigma2, double sigma3) {
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.sigma3 = sigma3;
    }

    public KernelGaussianCombination() {
    }

    @Override
    public double eval(double[] x, double[] y) {
        double norm2 = this.norm2(x, y);
        double exp1 = this.sigma1 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma1);
        double exp2 = this.sigma2 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma2);
        double exp3 = this.sigma3 == 0.0 ? 0.0 : Math.exp(-1.0 * norm2 / this.sigma3);
        return exp1 + exp2 - exp3;
    }

    public String toString() {
        return "gaussian combination kernel [sigma1 = " + this.sigma1 + ", sigma2 = " + this.sigma2 + ", sigma3 = " + this.sigma3 + "]";
    }
}

