/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.Kernel;

public class KernelEpanechnikov
extends Kernel {
    private static final long serialVersionUID = -1706678102534775619L;
    private double sigma = 1.0;
    private double degree = 1.0;

    public KernelEpanechnikov(double sigma, double degree) {
        this.sigma = sigma;
        this.degree = degree;
    }

    public KernelEpanechnikov() {
    }

    @Override
    public double eval(double[] x, double[] y) {
        double expression = this.norm2(x, y) / this.sigma;
        if (expression > 1.0) {
            return 0.0;
        }
        double minus = 1.0 - expression;
        return Math.pow(minus, this.degree);
    }

    public String toString() {
        return "epanechnikov kernel [sigma = " + this.sigma + ", degree = " + this.degree + "]";
    }
}

