/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm;

import Jama.Matrix;
import com.rapidminer.operator.learner.functions.kernel.rvm.Model;
import com.rapidminer.operator.learner.functions.kernel.rvm.Parameter;
import com.rapidminer.operator.learner.functions.kernel.rvm.RVMBase;
import com.rapidminer.operator.learner.functions.kernel.rvm.RegressionProblem;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelBasisFunction;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelRadial;
import com.rapidminer.operator.learner.functions.kernel.rvm.util.SECholeskyDecomposition;
import java.util.Iterator;
import java.util.LinkedList;

public class RVMRegression
extends RVMBase {
    public RVMRegression(RegressionProblem problem, Parameter parameter) {
        super(problem, parameter);
    }

    @Override
    public Model learn() {
        int i;
        int j;
        RegressionProblem problem = (RegressionProblem)this.problem;
        int numExamples = problem.getProblemSize();
        int numBases = numExamples + 1;
        double initBeta = 1.0 / Math.pow(this.parameter.initSigma, 2.0);
        double[][] x = problem.getInputVectors();
        KernelBasisFunction[] kernels = problem.getKernels();
        double[][] PHI = new double[numExamples][numBases];
        for (j = 0; j < numBases - 1; ++j) {
            for (i = 0; i < numExamples; ++i) {
                PHI[i][j + 1] = kernels[j + 1].eval(x[i]);
            }
        }
        for (i = 0; i < numExamples; ++i) {
            PHI[i][0] = 1.0;
        }
        double[] alphas = new double[numBases];
        for (j = 0; j < numBases; ++j) {
            alphas[j] = this.parameter.initAlpha;
        }
        Matrix matrixPHI = new Matrix(PHI);
        Matrix vectorT = new Matrix(problem.getTargetVectors());
        Matrix vectorAlpha = new Matrix(alphas, numBases);
        Matrix vectorPHI_T = matrixPHI.transpose().times(vectorT);
        LinkedList<Integer> unprunedIndicesList = null;
        int[] unprunedIndicesArray = null;
        Matrix prunedVectorWeights = null;
        for (i = 1; i <= this.parameter.maxIterations; ++i) {
            unprunedIndicesList = new LinkedList<Integer>();
            for (j = 0; j < numBases; ++j) {
                if (vectorAlpha.get(j, 0) >= this.parameter.alpha_max) continue;
                unprunedIndicesList.add(j);
            }
            unprunedIndicesArray = new int[unprunedIndicesList.size()];
            Iterator iter = unprunedIndicesList.iterator();
            for (j = 0; j < unprunedIndicesList.size(); ++j) {
                unprunedIndicesArray[j] = (Integer)iter.next();
            }
            Matrix prunedMatrixPHI = matrixPHI.getMatrix(0, matrixPHI.getRowDimension() - 1, unprunedIndicesArray);
            Matrix prunedVectorPHI_T = vectorPHI_T.getMatrix(unprunedIndicesArray, 0, 0);
            Matrix prunedVectorAlpha = vectorAlpha.getMatrix(unprunedIndicesArray, 0, 0);
            Matrix matrixAlphaDiag = new Matrix(prunedVectorAlpha.getRowDimension(), prunedVectorAlpha.getRowDimension(), 0.0);
            for (j = 0; j < prunedVectorAlpha.getRowDimension(); ++j) {
                matrixAlphaDiag.set(j, j, prunedVectorAlpha.get(j, 0));
            }
            Matrix matrixSIGMAInv = prunedMatrixPHI.transpose().times(prunedMatrixPHI);
            matrixSIGMAInv.timesEquals(initBeta);
            matrixSIGMAInv.plusEquals(matrixAlphaDiag);
            SECholeskyDecomposition CD = new SECholeskyDecomposition(matrixSIGMAInv.getArray());
            Matrix matrixU = CD.getPTR().times(CD.getL());
            Matrix matrixUInv = matrixU.inverse();
            prunedVectorWeights = matrixUInv.transpose().times(matrixUInv.times(prunedVectorPHI_T)).times(initBeta);
            double[] diagSIGMA = new double[matrixUInv.getRowDimension()];
            for (j = 0; j < diagSIGMA.length; ++j) {
                double value = 0.0;
                for (int k = 0; k < diagSIGMA.length; ++k) {
                    value += matrixUInv.get(k, j) * matrixUInv.get(k, j);
                }
                diagSIGMA[j] = value;
            }
            double[] gammas = new double[diagSIGMA.length];
            for (j = 0; j < gammas.length; ++j) {
                gammas[j] = 1.0 - prunedVectorAlpha.get(j, 0) * diagSIGMA[j];
            }
            double[] logAlphas = new double[prunedVectorAlpha.getRowDimension()];
            for (j = 0; j < logAlphas.length; ++j) {
                logAlphas[j] = Math.log(prunedVectorAlpha.get(j, 0));
            }
            for (j = 0; j < prunedVectorAlpha.getRowDimension(); ++j) {
                double newAlpha = gammas[j] / (prunedVectorWeights.get(j, 0) * prunedVectorWeights.get(j, 0));
                prunedVectorAlpha.set(j, 0, newAlpha);
            }
            double maxLogAlphaChange = 0.0;
            for (j = 0; j < logAlphas.length; ++j) {
                double change = Math.abs(logAlphas[j] - Math.log(prunedVectorAlpha.get(j, 0)));
                if (!(change > maxLogAlphaChange)) continue;
                maxLogAlphaChange = change;
            }
            if (maxLogAlphaChange < this.parameter.min_delta_log_alpha) break;
            double dataError = 0.0;
            Matrix dataDelta = vectorT.minus(prunedMatrixPHI.times(prunedVectorWeights));
            for (j = 0; j < numExamples; ++j) {
                dataError += dataDelta.get(j, 0) * dataDelta.get(j, 0);
            }
            double sumGammas = 0.0;
            for (j = 0; j < gammas.length; ++j) {
                sumGammas += gammas[j];
            }
            initBeta = ((double)numExamples - sumGammas) / dataError;
            for (j = 0; j < prunedVectorAlpha.getRowDimension(); ++j) {
                vectorAlpha.set(unprunedIndicesArray[j], 0, prunedVectorAlpha.get(j, 0));
            }
        }
        double[] finalWeights = new double[unprunedIndicesArray.length];
        KernelBasisFunction[] finalKernels = new KernelBasisFunction[unprunedIndicesArray.length];
        boolean bias = false;
        for (j = 0; j < unprunedIndicesArray.length; ++j) {
            finalWeights[j] = prunedVectorWeights.get(j, 0);
            if (unprunedIndicesArray[j] == 0) {
                bias = true;
                finalKernels[j] = new KernelBasisFunction(new KernelRadial());
                continue;
            }
            finalKernels[j] = kernels[unprunedIndicesArray[j]];
        }
        Model model = new Model(finalWeights, finalKernels, bias, true);
        return model;
    }

    public String toString() {
        return "Regression-RVM";
    }
}

