/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm;

import Jama.Matrix;
import com.rapidminer.operator.learner.functions.kernel.rvm.Model;
import com.rapidminer.operator.learner.functions.kernel.rvm.Parameter;
import com.rapidminer.operator.learner.functions.kernel.rvm.RVMBase;
import com.rapidminer.operator.learner.functions.kernel.rvm.RegressionProblem;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelBasisFunction;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelRadial;
import com.rapidminer.operator.learner.functions.kernel.rvm.util.SECholeskyDecomposition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

public class ConstructiveRegression
extends RVMBase {
    protected double[][] x;
    protected double[][] t;
    protected double[] tVector;
    protected double[][] phi;
    protected Matrix PHI_t;
    protected double[] alpha;
    protected double beta;
    protected Matrix A;
    protected Matrix SIGMA;
    protected Matrix SIGMA_chol;
    protected Matrix mu;
    protected double s;
    protected double q;
    protected LinkedList<Integer> basisSet = new LinkedList();
    private boolean useLocalRandomSeed;
    private int localRandomSeed;

    public ConstructiveRegression(RegressionProblem problem, Parameter parameter, boolean useLocalRandomSeed, int localRandomSeed) {
        super(problem, parameter);
        this.useLocalRandomSeed = useLocalRandomSeed;
        this.localRandomSeed = localRandomSeed;
    }

    protected double[] convertListToDoubleArray(List list) {
        double[] array = new double[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Double)list.get(i);
        }
        return array;
    }

    protected double innerProduct(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    protected void prune(LinkedList<Integer> basisSet) {
        int j;
        double[][] PHI_t_Array = new double[basisSet.size()][];
        for (j = 0; j < basisSet.size(); ++j) {
            PHI_t_Array[j] = this.phi[basisSet.get(j)];
        }
        this.PHI_t = new Matrix((double[][])PHI_t_Array);
        this.A = new Matrix(basisSet.size(), basisSet.size());
        for (j = 0; j < basisSet.size(); ++j) {
            this.A.set(j, j, this.alpha[basisSet.get(j)]);
        }
    }

    protected void updateSIGMA() {
        Matrix SIGMA_inv = this.PHI_t.times(this.PHI_t.transpose());
        SIGMA_inv.timesEquals(this.beta);
        SIGMA_inv.plusEquals(this.A);
        SECholeskyDecomposition CD = new SECholeskyDecomposition(SIGMA_inv.getArray());
        Matrix U = CD.getPTR().times(CD.getL());
        this.SIGMA_chol = U.inverse();
        this.SIGMA = this.SIGMA_chol.transpose().times(this.SIGMA_chol);
    }

    protected void updateMu() {
        this.mu = this.SIGMA.times(this.PHI_t.times(new Matrix(this.t)));
        this.mu.timesEquals(this.beta);
    }

    protected void updateCriteriumScalars(int selectedBasis) {
        Matrix SigmaStuff = this.PHI_t.transpose().times(this.SIGMA.times(this.PHI_t));
        double S = this.beta * this.innerProduct(this.phi[selectedBasis], this.phi[selectedBasis]) - this.beta * this.beta * this.innerProduct(this.phi[selectedBasis], SigmaStuff.times(new Matrix(this.phi[selectedBasis], this.phi[selectedBasis].length)).getRowPackedCopy());
        double Q = this.beta * this.innerProduct(this.phi[selectedBasis], this.tVector) - this.beta * this.beta * this.innerProduct(this.phi[selectedBasis], SigmaStuff.times(new Matrix(this.t)).getRowPackedCopy());
        this.s = this.alpha[selectedBasis] * S / (this.alpha[selectedBasis] - S);
        this.q = this.alpha[selectedBasis] * Q / (this.alpha[selectedBasis] - S);
    }

    protected void reestimateAlpha(int selectedBasis) {
        this.alpha[selectedBasis] = this.s * this.s / (this.q * this.q - this.s);
    }

    protected void includeBasis(int selectedBasis) {
        this.basisSet.add(selectedBasis);
        this.reestimateAlpha(selectedBasis);
    }

    protected void deleteBasis(int selectedBasis) {
        this.basisSet.remove((Object)selectedBasis);
        this.alpha[selectedBasis] = -1.0;
    }

    protected void updateBeta() {
        double[] gammas = new double[this.basisSet.size()];
        for (int j = 0; j < this.basisSet.size(); ++j) {
            gammas[j] = 1.0 - this.alpha[this.basisSet.get(j)] * this.SIGMA.get(j, j);
        }
        double sumGammas = 0.0;
        for (int j = 0; j < gammas.length; ++j) {
            sumGammas += gammas[j];
        }
        Matrix DELTA = new Matrix(this.t).minus(this.PHI_t.transpose().times(this.mu));
        this.beta = (double)this.x.length - sumGammas / this.innerProduct(DELTA.getRowPackedCopy(), DELTA.getRowPackedCopy());
    }

    @Override
    public Model learn() {
        int i;
        int j;
        RegressionProblem problem = (RegressionProblem)this.problem;
        int numExamples = problem.getProblemSize();
        int numBases = numExamples + 1;
        this.beta = Math.pow(0.5, -2.0);
        this.x = problem.getInputVectors();
        KernelBasisFunction[] kernels = problem.getKernels();
        this.phi = new double[numBases][numExamples];
        for (j = 0; j < numBases - 1; ++j) {
            for (i = 0; i < numExamples; ++i) {
                this.phi[j + 1][i] = kernels[j + 1].eval(this.x[i]);
            }
        }
        for (i = 0; i < numExamples; ++i) {
            this.phi[0][i] = 1.0;
        }
        this.t = problem.getTargetVectors();
        this.tVector = new double[this.t.length];
        for (i = 0; i < this.t.length; ++i) {
            this.tVector[i] = this.t[i][0];
        }
        this.alpha = new double[numBases];
        for (i = 0; i < this.alpha.length; ++i) {
            this.alpha[i] = -1.0;
        }
        int selectedBasis = RandomGenerator.getRandomGenerator(this.useLocalRandomSeed, this.localRandomSeed).nextInt();
        this.basisSet.add(selectedBasis);
        double normPhiSquare = this.innerProduct(this.phi[selectedBasis], this.phi[selectedBasis]);
        this.alpha[selectedBasis] = normPhiSquare / (this.innerProduct(this.phi[selectedBasis], this.tVector) / normPhiSquare - 1.0 / this.beta);
        for (i = 1; i <= this.parameter.maxIterations; ++i) {
            double[] logAlphas = new double[this.alpha.length];
            for (j = 0; j < logAlphas.length; ++j) {
                double value = Math.log(this.alpha[j]);
                if (Double.isNaN(value)) {
                    value = 0.0;
                }
                logAlphas[j] = value;
            }
            this.prune(this.basisSet);
            this.updateSIGMA();
            this.updateMu();
            this.updateBeta();
            selectedBasis = i % numBases;
            this.updateCriteriumScalars(selectedBasis);
            double theta = this.q * this.q - this.s;
            if (theta > 0.0) {
                if (this.alpha[selectedBasis] > 0.0) {
                    this.reestimateAlpha(selectedBasis);
                } else {
                    this.includeBasis(selectedBasis);
                }
            } else if (this.alpha[selectedBasis] > 0.0) {
                this.deleteBasis(selectedBasis);
            }
            double maxLogAlphaChange = 0.0;
            for (j = 0; j < logAlphas.length; ++j) {
                double change;
                double newValue = Math.log(this.alpha[j]);
                if (Double.isNaN(newValue)) {
                    newValue = 0.0;
                }
                if (!((change = Math.abs(logAlphas[j] - newValue)) > maxLogAlphaChange)) continue;
                maxLogAlphaChange = change;
            }
            if (Tools.isNotEqual(maxLogAlphaChange, 0.0) && maxLogAlphaChange < this.parameter.min_delta_log_alpha) break;
        }
        double[] finalWeights = new double[this.basisSet.size()];
        KernelBasisFunction[] finalKernels = new KernelBasisFunction[this.basisSet.size()];
        boolean bias = false;
        for (j = 0; j < this.basisSet.size(); ++j) {
            finalWeights[j] = this.mu.get(j, 0);
            if (this.basisSet.get(j) == 0) {
                bias = true;
                finalKernels[j] = new KernelBasisFunction(new KernelRadial());
                continue;
            }
            finalKernels[j] = kernels[this.basisSet.get(j)];
        }
        Model model = new Model(finalWeights, finalKernels, bias, true);
        return model;
    }

    public String toString() {
        return "Constructive-Regression-RVM";
    }
}

