/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.util;

public class Cache {
    protected Object[] elements = null;
    long counter = 0L;
    int cache_size = 0;
    long[] last_used = null;
    int[] index = null;

    public Cache() {
    }

    public Cache(int size, int dim) {
        this.init(size);
    }

    public void init(int size) {
        this.clean_cache();
        this.cache_size = size;
        if (this.cache_size < 1) {
            this.cache_size = 1;
        }
        this.elements = new Object[this.cache_size];
        this.last_used = new long[this.cache_size];
        this.index = new int[this.cache_size + 1];
        for (int i = 0; i < this.cache_size; ++i) {
            this.elements[i] = null;
            this.last_used[i] = 0L;
            this.index[i] = Integer.MAX_VALUE;
        }
        this.index[this.cache_size] = Integer.MAX_VALUE;
    }

    public void shrink(int size, int dim) {
        int i;
        Object[] new_elements = new Object[size];
        long[] new_last_used = new long[size];
        int[] new_index = new int[size + 1];
        if (size < this.cache_size) {
            this.cache_size = size;
        }
        for (i = 0; i < this.cache_size; ++i) {
            double[] element;
            double[] old_element = (double[])this.elements[i];
            if (old_element != null && this.last_used[i] > 0L) {
                element = new double[dim];
                System.arraycopy(old_element, 0, element, 0, dim);
            } else {
                element = null;
            }
            new_elements[i] = element;
            new_last_used[i] = this.last_used[i];
            new_index[i] = this.index[i];
            this.elements[i] = null;
        }
        while (i < size) {
            new_elements[i] = null;
            new_last_used[i] = 0L;
            new_index[i] = Integer.MAX_VALUE;
            ++i;
        }
        new_index[size] = Integer.MAX_VALUE;
        this.elements = new_elements;
        this.last_used = new_last_used;
        this.index = new_index;
        this.cache_size = size;
    }

    protected void clean_cache() {
        for (int i = 0; i < this.cache_size; ++i) {
            this.elements[i] = null;
        }
        this.elements = null;
        this.last_used = null;
        this.index = null;
    }

    public Object get_element(int i) {
        int pos = 0;
        Object result = null;
        pos = this.lookup(i);
        if (pos == this.cache_size) {
            --pos;
        }
        if (this.index[pos] == i && this.last_used[pos] > 0L) {
            result = this.elements[pos];
            this.last_used[pos] = ++this.counter;
        }
        return result;
    }

    public int get_lru_pos() {
        long[] my_last_used = this.last_used;
        long min_time = my_last_used[this.cache_size - 1];
        int low = this.cache_size - 1;
        for (int k = 0; k < this.cache_size; ++k) {
            if (my_last_used[k] >= min_time) continue;
            min_time = my_last_used[k];
            low = k;
        }
        return low;
    }

    public Object get_lru_element() {
        long[] my_last_used = this.last_used;
        long min_time = my_last_used[this.cache_size - 1];
        int low = this.cache_size - 1;
        for (int k = 0; k < this.cache_size; ++k) {
            if (my_last_used[k] >= min_time) continue;
            min_time = my_last_used[k];
            low = k;
        }
        return this.elements[low];
    }

    public void put_element(int i, Object o) {
        int low = 0;
        int high = this.cache_size;
        int pos = 0;
        high = this.lookup(i);
        pos = high == this.cache_size ? high - 1 : high;
        if (this.index[pos] != i || this.last_used[pos] == 0L) {
            low = this.index[pos] == i ? pos : this.get_lru_pos();
            Object[] my_elements = this.elements;
            long[] my_last_used = this.last_used;
            int[] my_index = this.index;
            if (high <= low) {
                for (int j = low; j > high; --j) {
                    my_elements[j] = my_elements[j - 1];
                    my_index[j] = my_index[j - 1];
                    my_last_used[j] = my_last_used[j - 1];
                }
            } else {
                for (int j = low; j < high - 1; ++j) {
                    my_elements[j] = my_elements[j + 1];
                    my_index[j] = my_index[j + 1];
                    my_last_used[j] = my_last_used[j + 1];
                }
                --high;
            }
            pos = high;
            my_elements[high] = o;
            my_index[high] = i;
        }
        this.last_used[pos] = ++this.counter;
    }

    protected int lookup(int i) {
        int[] my_index = this.index;
        int low = 0;
        int high = this.cache_size;
        while (low < high) {
            int med = low + high >>> 1;
            if (my_index[med] >= i) {
                high = med;
                continue;
            }
            low = med + 1;
        }
        return high;
    }

    public boolean cached(int i) {
        int pos = this.lookup(i);
        boolean ok = this.index[pos] == i ? this.last_used[pos] > 0L : false;
        return ok;
    }

    public void renew(int i) {
        int pos = this.lookup(i);
        if (this.index[pos] == i && this.last_used[pos] > 0L) {
            this.last_used[pos] = ++this.counter;
        }
    }

    public void swap(int i, int j) {
        int pos_i = this.lookup(i);
        int pos_j = this.lookup(j);
        if (this.index[pos_i] == i && this.index[pos_j] == j) {
            Object dummy = this.elements[pos_i];
            this.elements[pos_i] = this.elements[pos_j];
            this.elements[pos_j] = dummy;
            this.last_used[pos_i] = this.last_used[pos_j];
            this.last_used[pos_j] = 0L;
        } else if (this.index[pos_i] == i) {
            this.last_used[pos_i] = 0L;
        } else if (this.index[pos_j] == j) {
            this.last_used[pos_j] = 0L;
        }
        for (pos_i = 0; pos_i < this.cache_size; ++pos_i) {
            double[] my_row = (double[])this.elements[pos_i];
            if (my_row == null) continue;
            double dummy_d = my_row[i];
            my_row[i] = my_row[j];
            my_row[j] = dummy_d;
        }
    }
}

