/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;

public class KernelRadial
extends Kernel {
    private static final long serialVersionUID = -4479949116041525534L;
    private double gamma = -1.0;

    @Override
    public String toString() {
        return "rbf(" + -this.gamma + ")";
    }

    public double getGamma() {
        return -this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = -gamma;
    }

    @Override
    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        return Math.exp(this.gamma * this.norm2(x_index, x_att, y_index, y_att));
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer("exp(");
        result.append(this.gamma + " * (");
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append(valueString + " * " + valueString);
            } else {
                result.append(" + " + valueString + " * " + valueString);
            }
            first = false;
        }
        result.append("))");
        return result.toString();
    }
}

