/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.tools.Tools;

public class KernelPolynomial
extends Kernel {
    private static final long serialVersionUID = 7385441798122306059L;
    private double degree = 2.0;

    @Override
    public String toString() {
        return "poly(" + this.degree + ")";
    }

    public void setDegree(double degree) {
        this.degree = degree;
    }

    @Override
    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double prod;
        double result = prod = this.innerproduct(x_index, x_att, y_index, y_att);
        int i = 1;
        while ((double)i < this.degree) {
            result *= prod;
            ++i;
        }
        return result;
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer innerProductString = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            if (Tools.isZero(value)) continue;
            if (value < 0.0) {
                if (first) {
                    innerProductString.append("-" + Math.abs(value) + " * " + attributeConstructions[i]);
                } else {
                    innerProductString.append(" - " + Math.abs(value) + " * " + attributeConstructions[i]);
                }
            } else if (first) {
                innerProductString.append(value + " * " + attributeConstructions[i]);
            } else {
                innerProductString.append(" + " + value + " * " + attributeConstructions[i]);
            }
            first = false;
        }
        StringBuffer result = new StringBuffer("(" + innerProductString.toString() + ")");
        int i = 1;
        while ((double)i < this.degree) {
            result.append(" * (" + innerProductString.toString() + ")");
            ++i;
        }
        return result.toString();
    }

    public double getDegree() {
        return this.degree;
    }
}

