/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.tools.Tools;

public class KernelNeural
extends Kernel {
    private static final long serialVersionUID = 3862702323530107467L;
    double a = 1.0;
    double b = 0.0;

    @Override
    public String toString() {
        return "neural(" + this.a + "," + this.b + ")";
    }

    public void setParameters(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double prod = this.a * this.innerproduct(x_index, x_att, y_index, y_att) + this.b;
        double e1 = Math.exp(prod);
        double e2 = Math.exp(-prod);
        return (e1 - e2) / (e1 + e2);
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            if (Tools.isZero(value)) continue;
            if (value < 0.0) {
                if (first) {
                    result.append("-" + Math.abs(value) + " * " + attributeConstructions[i]);
                } else {
                    result.append(" - " + Math.abs(value) + " * " + attributeConstructions[i]);
                }
            } else if (first) {
                result.append(value + " * " + attributeConstructions[i]);
            } else {
                result.append(" + " + value + " * " + attributeConstructions[i]);
            }
            first = false;
        }
        String e1 = "exp(" + result.toString() + ")";
        String e2 = "exp(-1 * (" + result.toString() + "))";
        return "((" + e1 + " - " + e2 + ") / (" + e1 + " + " + e2 + "))";
    }
}

