/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;

public class KernelAnova
extends Kernel {
    private static final long serialVersionUID = -8670034220969832253L;
    private double sigma = 1.0;
    private double degree = 1.0;

    public void setParameters(double sigma, double degree) {
        this.sigma = sigma;
        this.degree = degree;
    }

    @Override
    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        double tmp;
        double result = 0.0;
        int xpos = x_index.length - 1;
        int ypos = y_index.length - 1;
        int zeros = this.dim;
        while (xpos >= 0 && ypos >= 0) {
            if (x_index[xpos] == y_index[ypos]) {
                tmp = x_att[xpos] - y_att[ypos];
                result += Math.exp(-this.sigma * tmp * tmp);
                --xpos;
                --ypos;
            } else if (x_index[xpos] > y_index[ypos]) {
                tmp = x_att[xpos];
                result += Math.exp(-this.sigma * tmp * tmp);
                --xpos;
            } else {
                tmp = y_att[ypos];
                result += Math.exp(-this.sigma * tmp * tmp);
                --ypos;
            }
            --zeros;
        }
        while (xpos >= 0) {
            tmp = x_att[xpos];
            result += Math.exp(-this.sigma * tmp * tmp);
            --xpos;
            --zeros;
        }
        while (ypos >= 0) {
            tmp = y_att[ypos];
            result += Math.exp(-this.sigma * tmp * tmp);
            --ypos;
            --zeros;
        }
        return Math.pow(result += (double)zeros, this.degree);
    }

    @Override
    public String toString() {
        return "anova(s = " + this.sigma + ", d = " + this.degree + ")";
    }

    @Override
    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer result = new StringBuffer();
        result.append("pow((");
        boolean first = true;
        for (int i = 0; i < x.length; ++i) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                result.append("exp(-" + this.sigma + " * " + valueString + " * " + valueString + ")");
            } else {
                result.append(" + exp(-" + this.sigma + " * " + valueString + " * " + valueString + ")");
            }
            first = false;
        }
        result.append("), " + this.degree + ")");
        return result.toString();
    }
}

