/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.hyperhyper;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;

public class HyperModel
extends PredictionModel {
    private static final long serialVersionUID = -453402008180607969L;
    private String[] coefficientNames;
    private double[] x1;
    private double[] x2;
    private double bias;
    private double[] w;

    public HyperModel(ExampleSet trainingExampleSet, double bias, double[] w, double[] x1, double[] x2) {
        super(trainingExampleSet);
        this.coefficientNames = Tools.getRegularAttributeNames(trainingExampleSet);
        this.bias = bias;
        this.w = w;
        this.x1 = x1;
        this.x2 = x2;
    }

    public int getNumberOfAttributes() {
        return this.x1.length;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("Support Vector 1:" + com.rapidminer.tools.Tools.getLineSeparator());
        for (i = 0; i < this.coefficientNames.length; ++i) {
            result.append(this.coefficientNames[i]).append(" = ").append(com.rapidminer.tools.Tools.formatNumber(this.x1[i])).append(com.rapidminer.tools.Tools.getLineSeparator());
        }
        result.append(com.rapidminer.tools.Tools.getLineSeparator()).append("Support Vector 2:").append(com.rapidminer.tools.Tools.getLineSeparator());
        for (i = 0; i < this.coefficientNames.length; ++i) {
            result.append(this.coefficientNames[i] + " = " + com.rapidminer.tools.Tools.formatNumber(this.x2[i]) + com.rapidminer.tools.Tools.getLineSeparator());
        }
        result.append(com.rapidminer.tools.Tools.getLineSeparator()).append("Bias (offset): ").append(com.rapidminer.tools.Tools.formatNumber(this.bias)).append(com.rapidminer.tools.Tools.getLineSeparators(2));
        result.append("Coefficients:").append(com.rapidminer.tools.Tools.getLineSeparator());
        for (int j = 0; j < this.w.length; ++j) {
            result.append("w(").append(this.coefficientNames[j]).append(") = ").append(com.rapidminer.tools.Tools.formatNumber(this.w[j])).append(com.rapidminer.tools.Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public String getName() {
        return "HyperHyper Model";
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        if (exampleSet.getAttributes().size() != this.getNumberOfAttributes()) {
            throw new UserError(null, 133, this.getNumberOfAttributes(), exampleSet.getAttributes().size());
        }
        for (Example activeExample : exampleSet) {
            double sum = 0.0;
            int i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                sum += activeExample.getValue(attribute) * this.w[i];
                ++i;
            }
            double result = sum + this.bias;
            int prediction = 0;
            prediction = result > 0.0 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
            activeExample.setValue(predictedLabel, prediction);
            activeExample.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-result)));
            activeExample.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(result)));
        }
        return exampleSet;
    }

    private DataTable createWeightsTable() {
        SimpleDataTable weightTable = new SimpleDataTable("Hyper Weights", new String[]{"Attribute", "Weight"});
        for (int j = 0; j < this.w.length; ++j) {
            int nameIndex = weightTable.mapString(0, this.coefficientNames[j]);
            weightTable.add(new SimpleDataTableRow(new double[]{nameIndex, this.w[j]}));
        }
        return weightTable;
    }

    public DataTable getWeightTable() {
        return this.createWeightsTable();
    }
}

