/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.hyperhyper;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.kernel.hyperhyper.HyperModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Vector;

public class HyperHyper
extends AbstractLearner {
    public HyperHyper(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        if (exampleSet.getAttributes().getWeight() == null) {
            Tools.createWeightAttribute(exampleSet);
        }
        double weightSum = 0.0;
        for (Example e : exampleSet) {
            weightSum += e.getWeight();
        }
        Attribute label = exampleSet.getAttributes().getLabel();
        Example x1 = this.rejectionSampling(exampleSet, weightSum);
        Example x2 = null;
        int tries = 0;
        do {
            x2 = this.rejectionSampling(exampleSet, weightSum);
            if (++tries < 10) continue;
            Vector<Example> examplesWithWantedLabel = new Vector<Example>();
            for (Example ex : exampleSet) {
                if (ex.getValue(label) == x1.getValue(label)) continue;
                examplesWithWantedLabel.add(ex);
            }
            RandomGenerator random = RandomGenerator.getRandomGenerator(this);
            boolean doSampling = true;
            while (doSampling) {
                int index = random.nextInt(examplesWithWantedLabel.size());
                if (!(random.nextDouble() < ((Example)examplesWithWantedLabel.get(index)).getWeight() / weightSum)) continue;
                x2 = (Example)examplesWithWantedLabel.get(index);
                doSampling = false;
            }
        } while (x1.getValue(label) == x2.getValue(label));
        double[] w = new double[x1.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            w[i] = x1.getValue(attribute) - x2.getValue(attribute);
            ++i;
        }
        double bx1 = 0.0;
        double bx2 = 0.0;
        i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            bx1 += x1.getValue(attribute) * w[i];
            bx2 += x2.getValue(attribute) * w[i];
            ++i;
        }
        double b = (bx1 + bx2) * -0.5;
        double[] x1Values = new double[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            x1Values[counter++] = x1.getValue(attribute);
        }
        double[] x2Values = new double[exampleSet.getAttributes().size()];
        counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            x2Values[counter++] = x2.getValue(attribute);
        }
        return new HyperModel(exampleSet, b, w, x1Values, x2Values);
    }

    private Example rejectionSampling(ExampleSet exampleSet, double weightSum) throws OperatorException {
        Example example = null;
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        boolean doSampling = true;
        while (doSampling) {
            int index = random.nextInt(exampleSet.size());
            if (!(random.nextDouble() < exampleSet.getExample(index).getWeight() / weightSum)) continue;
            example = exampleSet.getExample(index);
            doSampling = false;
        }
        return example;
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return HyperModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return capability == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), HyperHyper.class, null);
    }
}

