/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.operator.learner.functions.kernel.evosvm.OptimizationFunction;
import com.rapidminer.tools.math.kernels.Kernel;

public class RegressionOptimizationFunction
implements OptimizationFunction {
    private double epsilon;

    public RegressionOptimizationFunction(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public double[] getFitness(double[] alphas, double[] ys, Kernel kernel) {
        int offset = ys.length;
        double matrixSum = 0.0;
        for (int i = 0; i < ys.length; ++i) {
            for (int j = 0; j < ys.length; ++j) {
                matrixSum += (alphas[i] - alphas[i + offset]) * (alphas[j] - alphas[j + offset]) * kernel.getDistance(i, j);
            }
        }
        double alphaSum = 0.0;
        for (int i = 0; i < ys.length; ++i) {
            alphaSum += alphas[i] + alphas[i + offset];
        }
        double labelSum = 0.0;
        for (int i = 0; i < ys.length; ++i) {
            labelSum += ys[i] * (alphas[i] - alphas[i + offset]);
        }
        return new double[]{-0.5 * matrixSum - this.epsilon * alphaSum + labelSum, 0.0};
    }
}

