/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.evosvm.PSOSVMOptimization;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.List;

public class PSOSVM
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_MAX_EVALUATIONS = "max_evaluations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_INERTIA_WEIGHT = "inertia_weight";
    public static final String PARAMETER_LOCAL_BEST_WEIGHT = "local_best_weight";
    public static final String PARAMETER_GLOBAL_BEST_WEIGHT = "global_best_weight";
    public static final String PARAMETER_DYNAMIC_INERTIA_WEIGHT = "dynamic_inertia_weight";

    public PSOSVM(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), label.getName());
        }
        Kernel kernel = Kernel.createKernel(this);
        PSOSVMOptimization optimization = new PSOSVMOptimization(exampleSet, kernel, this.getParameterAsDouble(PARAMETER_C), this.getParameterAsInt(PARAMETER_MAX_EVALUATIONS), this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), this.getParameterAsInt(PARAMETER_POPULATION_SIZE), this.getParameterAsDouble(PARAMETER_INERTIA_WEIGHT), this.getParameterAsDouble(PARAMETER_LOCAL_BEST_WEIGHT), this.getParameterAsDouble(PARAMETER_GLOBAL_BEST_WEIGHT), this.getParameterAsBoolean(PARAMETER_DYNAMIC_INERTIA_WEIGHT), this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT), RandomGenerator.getRandomGenerator(this));
        optimization.optimize();
        double[] bestAlphas = optimization.getBestValuesEver();
        return optimization.getModel(bestAlphas);
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return lc == OperatorCapability.FORMULA_PROVIDER;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT, "Indicates if a dialog with a convergence plot should be drawn.", false));
        types.addAll(Kernel.getParameters(this));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_C, "The SVM complexity constant (0: calculates probably good value).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_EVALUATIONS, "Stop after this many evaluations", 1, Integer.MAX_VALUE, 500));
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeDouble(PARAMETER_INERTIA_WEIGHT, "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeDouble(PARAMETER_LOCAL_BEST_WEIGHT, "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_GLOBAL_BEST_WEIGHT, "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_DYNAMIC_INERTIA_WEIGHT, "If set to true the inertia weight is improved during run.", true));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), PSOSVM.class, null);
    }
}

