/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.evosvm.ClassificationEvoOptimization;
import com.rapidminer.operator.learner.functions.kernel.evosvm.EvoOptimization;
import com.rapidminer.operator.learner.functions.kernel.evosvm.RegressionEvoOptimization;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import java.util.List;

public class EvoSVM
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_START_POPULATION_TYPE = "start_population_type";
    public static final String PARAMETER_MAX_GENERATIONS = "max_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_MUTATION_TYPE = "mutation_type";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_CROSSOVER_PROB = "crossover_prob";
    public static final String PARAMETER_HOLD_OUT_SET_RATIO = "hold_out_set_ratio";
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    public static final String PARAMETER_SHOW_POPULATION_PLOT = "show_population_plot";
    public static final String PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE = "return_optimization_performance";
    private EvoOptimization optimization;

    public EvoSVM(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean shouldDeliverOptimizationPerformance() {
        return this.getParameterAsBoolean(PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE);
    }

    @Override
    public PerformanceVector getOptimizationPerformance() {
        return this.optimization.getOptimizationPerformance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Kernel kernel = Kernel.createKernel(this);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal()) {
            if (label.getMapping().size() != 2) throw new UserError((Operator)this, 114, this.getName(), label.getName());
            ExampleSet holdOutSet = null;
            ExampleSet trainingSet = exampleSet;
            double holdOutSetRatio = this.getParameterAsDouble(PARAMETER_HOLD_OUT_SET_RATIO);
            if (!Tools.isZero(holdOutSetRatio)) {
                SplittedExampleSet splittedExampleSet = new SplittedExampleSet(exampleSet, new double[]{1.0 - holdOutSetRatio, holdOutSetRatio}, 1, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
                splittedExampleSet.selectSingleSubset(0);
                trainingSet = (ExampleSet)splittedExampleSet.clone();
                splittedExampleSet.selectAllSubsetsBut(0);
                holdOutSet = (ExampleSet)splittedExampleSet.clone();
            }
            this.optimization = new ClassificationEvoOptimization(trainingSet, kernel, this.getParameterAsDouble(PARAMETER_C), this.getParameterAsInt(PARAMETER_START_POPULATION_TYPE), this.getParameterAsInt(PARAMETER_MAX_GENERATIONS), this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), this.getParameterAsInt(PARAMETER_POPULATION_SIZE), this.getParameterAsInt(PARAMETER_SELECTION_TYPE), this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION), this.getParameterAsBoolean(PARAMETER_KEEP_BEST), this.getParameterAsInt(PARAMETER_MUTATION_TYPE), this.getParameterAsDouble(PARAMETER_CROSSOVER_PROB), this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT), this.getParameterAsBoolean(PARAMETER_SHOW_POPULATION_PLOT), holdOutSet, random, (LoggingHandler)this);
            return this.optimization.train();
        } else {
            this.optimization = new RegressionEvoOptimization(exampleSet, kernel, this.getParameterAsDouble(PARAMETER_C), this.getParameterAsDouble(PARAMETER_EPSILON), this.getParameterAsInt(PARAMETER_START_POPULATION_TYPE), this.getParameterAsInt(PARAMETER_MAX_GENERATIONS), this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), this.getParameterAsInt(PARAMETER_POPULATION_SIZE), this.getParameterAsInt(PARAMETER_SELECTION_TYPE), this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION), this.getParameterAsBoolean(PARAMETER_KEEP_BEST), this.getParameterAsInt(PARAMETER_MUTATION_TYPE), this.getParameterAsDouble(PARAMETER_CROSSOVER_PROB), this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT), this.getParameterAsBoolean(PARAMETER_SHOW_POPULATION_PLOT), random, (LoggingHandler)this);
        }
        return this.optimization.train();
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.NUMERICAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return lc == OperatorCapability.FORMULA_PROVIDER;
    }

    public static double[] createBoundArray(double bound, int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bound;
        }
        return result;
    }

    public static final double[] determineMax(double _c, Kernel kernel, ExampleSet exampleSet, int selectionType, int arraySize) {
        double[] max = new double[arraySize];
        kernel.init(exampleSet);
        double globalC = 1000.0;
        if (selectionType != 7) {
            if (_c <= 0.0) {
                double c = 0.0;
                for (int i = 0; i < exampleSet.size(); ++i) {
                    c += kernel.getDistance(i, i);
                }
                globalC = (double)exampleSet.size() / c;
                exampleSet.getLog().log("Determine probably good value for C: set to " + c);
            } else {
                globalC = _c;
            }
        }
        for (int i = 0; i < max.length; ++i) {
            max[i] = globalC;
        }
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        if (weightAttribute != null) {
            int counter = 0;
            for (Example e : exampleSet) {
                int n = counter++;
                max[n] = max[n] * e.getValue(weightAttribute);
            }
        }
        return max;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(Kernel.getParameters(this));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_C, "The SVM complexity constant (0: calculates probably good value).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_EPSILON, "The width of the regression tube loss function of the regression SVM", 0.0, Double.POSITIVE_INFINITY, 0.1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_START_POPULATION_TYPE, "The type of start population initialization.", ESOptimization.POPULATION_INIT_TYPES, 0));
        types.add(new ParameterTypeInt(PARAMETER_MAX_GENERATIONS, "Stop after this many evaluations", 1, Integer.MAX_VALUE, 10000));
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after this number of generations without improvement (-1: optimize until max_iterations).", -1, Integer.MAX_VALUE, 30));
        types.add(new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "The population size (-1: number of examples)", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble(PARAMETER_TOURNAMENT_FRACTION, "The fraction of the population used for tournament selection.", 0.0, Double.POSITIVE_INFINITY, 0.75));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_BEST, "Indicates if the best individual should survive (elititst selection).", true));
        types.add(new ParameterTypeCategory(PARAMETER_MUTATION_TYPE, "The type of the mutation operator.", ESOptimization.MUTATION_TYPES, 1));
        types.add(new ParameterTypeCategory(PARAMETER_SELECTION_TYPE, "The type of the selection operator.", ESOptimization.SELECTION_TYPES, 6));
        types.add(new ParameterTypeDouble(PARAMETER_CROSSOVER_PROB, "The probability for crossovers.", 0.0, 1.0, 1.0));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        types.add(new ParameterTypeDouble(PARAMETER_HOLD_OUT_SET_RATIO, "Uses this amount as a hold out set to estimate generalization error after learning (currently only used for multi-objective classification).", 0.0, 1.0, 0.0));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT, "Indicates if a dialog with a convergence plot should be drawn.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_POPULATION_PLOT, "Indicates if the population plot in case of the non-dominated sorting should be shown.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE, "Indicates if final optimization fitness should be returned as performance.", false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), EvoSVM.class, null);
    }
}

