/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.operator.learner.functions.kernel.evosvm.OptimizationFunction;
import com.rapidminer.tools.math.kernels.Kernel;

public class ClassificationOptimizationFunction
implements OptimizationFunction {
    private boolean multiobjective;

    public ClassificationOptimizationFunction(boolean multiobjective) {
        this.multiobjective = multiobjective;
    }

    @Override
    public double[] getFitness(double[] alphas, double[] ys, Kernel kernel) {
        double sum = 0.0;
        double alphaLabelSum = 0.0;
        int numberSV = 0;
        for (int i = 0; i < ys.length; ++i) {
            sum += alphas[i];
            alphaLabelSum += ys[i] * alphas[i];
            if (!(alphas[i] > 0.0)) continue;
            ++numberSV;
        }
        double matrixSum = 0.0;
        for (int i = 0; i < ys.length; ++i) {
            if (alphas[i] == 0.0) continue;
            for (int j = 0; j < ys.length; ++j) {
                if (alphas[j] == 0.0) continue;
                matrixSum += alphas[i] * alphas[j] * ys[i] * ys[j] * kernel.getDistance(i, j);
            }
        }
        alphaLabelSum = -Math.abs(alphaLabelSum);
        if (this.multiobjective) {
            return new double[]{sum, -matrixSum, alphaLabelSum};
        }
        return new double[]{sum - 0.5 * matrixSum};
    }
}

