/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import java.util.Map;

public class LinearMySVMModel
extends PredictionModel {
    private static final long serialVersionUID = 2812901947459843681L;
    private Map<Integer, SVMExamples.MeanVariance> meanVariances;
    private double bias;
    private double[] weights = null;

    public LinearMySVMModel(ExampleSet exampleSet, SVMExamples model, Kernel kernel, int kernelType) {
        super(exampleSet);
        this.meanVariances = model.getMeanVariances();
        this.bias = model.get_b();
        this.weights = new double[model.get_dim()];
        for (int i = 0; i < model.count_examples(); ++i) {
            double[] x = model.get_example(i).toDense(model.get_dim());
            double alpha = model.get_alpha(i);
            double y = model.get_y(i);
            if (y != 0.0) {
                alpha /= y;
            }
            for (int j = 0; j < this.weights.length; ++j) {
                int n = j;
                this.weights[n] = this.weights[n] + y * alpha * x[j];
            }
        }
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        for (Example example : exampleSet) {
            double prediction = this.bias;
            int a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = example.getValue(attribute);
                SVMExamples.MeanVariance meanVariance = this.meanVariances.get(a);
                if (meanVariance != null) {
                    value = meanVariance.getVariance() == 0.0 ? 0.0 : (value - meanVariance.getMean()) / Math.sqrt(meanVariance.getVariance());
                }
                prediction += this.weights[a] * value;
                ++a;
            }
            if (predictedLabelAttribute.isNominal()) {
                int index = prediction > 0.0 ? predictedLabelAttribute.getMapping().getPositiveIndex() : predictedLabelAttribute.getMapping().getNegativeIndex();
                example.setValue(predictedLabelAttribute, index);
                example.setConfidence(predictedLabelAttribute.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-prediction)));
                example.setConfidence(predictedLabelAttribute.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(prediction)));
                continue;
            }
            example.setValue(predictedLabelAttribute, prediction);
        }
        return exampleSet;
    }
}

