/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.LinearMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelDot;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMpattern;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMregression;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class LinearMySVMLearner
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_KERNEL_CACHE = "kernel_cache";
    public static final String PARAMETER_CONVERGENCE_EPSILON = "convergence_epsilon";
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_SCALE = "scale";
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_L_POS = "L_pos";
    public static final String PARAMETER_L_NEG = "L_neg";
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_EPSILON_PLUS = "epsilon_plus";
    public static final String PARAMETER_EPSILON_MINUS = "epsilon_minus";
    public static final String PARAMETER_BALANCE_COST = "balance_cost";
    public static final String PARAMETER_QUADRATIC_LOSS_POS = "quadratic_loss_pos";
    public static final String PARAMETER_QUADRATIC_LOSS_NEG = "quadratic_loss_neg";
    public static final int KERNEL_DOT = 0;
    private SVMExamples svmExamples;

    public LinearMySVMLearner(OperatorDescription description) {
        super(description);
    }

    protected SVMInterface createSVM(Attribute label, Kernel kernel, SVMExamples sVMExamples, ExampleSet rapidMinerExamples) throws OperatorException {
        if (label.isNominal()) {
            return new SVMpattern(this, kernel, sVMExamples, rapidMinerExamples, RandomGenerator.getGlobalRandomGenerator());
        }
        return new SVMregression(this, kernel, sVMExamples, rapidMinerExamples, RandomGenerator.getGlobalRandomGenerator());
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), label.getName());
        }
        this.svmExamples = new SVMExamples(exampleSet, label, this.getParameterAsBoolean(PARAMETER_SCALE));
        int cacheSize = this.getParameterAsInt(PARAMETER_KERNEL_CACHE);
        KernelDot kernel = new KernelDot();
        kernel.init(this.svmExamples, cacheSize);
        SVMInterface svm = this.createSVM(label, kernel, this.svmExamples, exampleSet);
        svm.init(kernel, this.svmExamples);
        svm.train();
        LinearMySVMModel model = new LinearMySVMModel(exampleSet, this.svmExamples, kernel, 0);
        this.svmExamples = null;
        return model;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.NUMERICAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return lc == OperatorCapability.FORMULA_PROVIDER;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_KERNEL_CACHE, "Size of the cache for kernel evaluations im MB ", 0, Integer.MAX_VALUE, 200));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_C, "The SVM complexity constant. Use -1 for different C values for positive and negative.", -1.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_CONVERGENCE_EPSILON, "Precision on the KKT conditions", 0.0, Double.POSITIVE_INFINITY, 0.001);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "Stop after this many iterations", 1, Integer.MAX_VALUE, 100000));
        types.add(new ParameterTypeBoolean(PARAMETER_SCALE, "Scale the example values and store the scaling parameters for test set.", true));
        types.add(new ParameterTypeDouble(PARAMETER_L_POS, "A factor for the SVM complexity constant for positive examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_L_NEG, "A factor for the SVM complexity constant for negative examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Insensitivity constant. No loss if prediction lies this close to true value", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON_PLUS, "Epsilon for positive deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON_MINUS, "Epsilon for negative deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeBoolean(PARAMETER_BALANCE_COST, "Adapts Cpos and Cneg to the relative size of the classes", false));
        types.add(new ParameterTypeBoolean(PARAMETER_QUADRATIC_LOSS_POS, "Use quadratic loss for positive deviation", false));
        types.add(new ParameterTypeBoolean(PARAMETER_QUADRATIC_LOSS_NEG, "Use quadratic loss for negative deviation", false));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), LinearMySVMLearner.class, null);
    }
}

