/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.FastExample2SparseTransform;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.LibSVMModel;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.quickfix.CategorySelectionQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import libsvm.Svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public class LibSVMLearner
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_SVM_TYPE = "svm_type";
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_DEGREE = "degree";
    public static final String PARAMETER_GAMMA = "gamma";
    public static final String PARAMETER_COEF0 = "coef0";
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_NU = "nu";
    public static final String PARAMETER_CACHE_SIZE = "cache_size";
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_CLASS_WEIGHTS = "class_weights";
    public static final String PARAMETER_SHRINKING = "shrinking";
    public static final String PARAMETER_CALCULATE_CONFIDENCES = "calculate_confidences";
    public static final String PARAMETER_ONECLASS_CLASSIFICATION = "one_class_classification";
    public static final String PARAMETER_CONFIDENCE_FOR_MULTICLASS = "confidence_for_multiclass";
    public static final String[] SVM_TYPES = new String[]{"C-SVC", "nu-SVC", "one-class", "epsilon-SVR", "nu-SVR"};
    public static final int SVM_TYPE_C_SVC = 0;
    public static final int SVM_TYPE_NU_SVC = 1;
    public static final int SVM_TYPE_ONE_CLASS = 2;
    public static final int SVM_TYPE_EPS_SVR = 3;
    public static final int SVM_TYPE_NU_SVR = 4;
    public static final String[] KERNEL_TYPES = new String[]{"linear", "poly", "rbf", "sigmoid", "precomputed"};

    public LibSVMLearner(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new SimplePrecondition(this.getExampleSetInputPort(), null, false){

            @Override
            public void makeAdditionalChecks(MetaData received) {
                if (received instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)received;
                    switch (emd.hasSpecial("label")) {
                        case NO: 
                        case UNKNOWN: {
                            return;
                        }
                        case YES: {
                            try {
                                AttributeMetaData label = emd.getLabelMetaData();
                                if (label.isNominal()) {
                                    if (LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE) != 4 && LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE) != 3) break;
                                    LibSVMLearner.this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)LibSVMLearner.this.getExampleSetInputPort(), Collections.singletonList(new CategorySelectionQuickFix(LibSVMLearner.this, LibSVMLearner.PARAMETER_SVM_TYPE, new String[]{SVM_TYPES[0], SVM_TYPES[1], SVM_TYPES[2]}, SVM_TYPES[LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE)], "Select appropriate svm_type for " + (Object)((Object)OperatorCapability.POLYNOMINAL_LABEL))), "parameters.cannot_handle", new Object[]{OperatorCapability.POLYNOMINAL_LABEL, LibSVMLearner.PARAMETER_SVM_TYPE, SVM_TYPES[LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE)]}));
                                    break;
                                }
                                if (!label.isNumerical() || LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE) != 1 && LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE) != 0) break;
                                LibSVMLearner.this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)LibSVMLearner.this.getExampleSetInputPort(), Collections.singletonList(new CategorySelectionQuickFix(LibSVMLearner.this, LibSVMLearner.PARAMETER_SVM_TYPE, new String[]{SVM_TYPES[4], SVM_TYPES[3]}, SVM_TYPES[LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE)], "Select appropriate svm_type for " + (Object)((Object)OperatorCapability.NUMERICAL_LABEL))), "parameters.cannot_handle", new Object[]{OperatorCapability.NUMERICAL_LABEL, LibSVMLearner.PARAMETER_SVM_TYPE, SVM_TYPES[LibSVMLearner.this.getParameterAsInt(LibSVMLearner.PARAMETER_SVM_TYPE)]}));
                                break;
                            }
                            catch (UndefinedParameterError undefinedParameterError) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        try {
            int type = this.getParameterAsInt(PARAMETER_SVM_TYPE);
            switch (lc) {
                case NUMERICAL_ATTRIBUTES: 
                case FORMULA_PROVIDER: {
                    return true;
                }
                case BINOMINAL_LABEL: 
                case POLYNOMINAL_LABEL: {
                    if (type != 1 && type != 0) break;
                    return true;
                }
                case ONE_CLASS_LABEL: {
                    if (type != 2) break;
                    return true;
                }
                case NUMERICAL_LABEL: {
                    if (type != 4 && type != 3) break;
                    return true;
                }
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return false;
    }

    protected static svm_node[] makeNodes(Example e, FastExample2SparseTransform ripper) {
        int[] nonDefaultIndices = ripper.getNonDefaultAttributeIndices(e);
        double[] nonDefaultValues = ripper.getNonDefaultAttributeValues(e, nonDefaultIndices);
        svm_node[] nodeArray = new svm_node[nonDefaultIndices.length];
        for (int a = 0; a < nonDefaultIndices.length; ++a) {
            svm_node node = new svm_node();
            node.index = nonDefaultIndices[a];
            node.value = nonDefaultValues[a];
            nodeArray[a] = node;
        }
        return nodeArray;
    }

    private svm_problem getProblem(ExampleSet exampleSet) throws UserError {
        this.log("Creating LibSVM problem.");
        FastExample2SparseTransform ripper = new FastExample2SparseTransform(exampleSet);
        int nodeCount = 0;
        svm_problem problem = new svm_problem();
        problem.l = exampleSet.size();
        problem.y = new double[exampleSet.size()];
        problem.x = new svm_node[exampleSet.size()][];
        Iterator i = exampleSet.iterator();
        Attribute label = exampleSet.getAttributes().getLabel();
        int j = 0;
        while (i.hasNext()) {
            Example e = (Example)i.next();
            problem.x[j] = LibSVMLearner.makeNodes(e, ripper);
            problem.y[j] = e.getValue(label);
            nodeCount += problem.x[j].length;
            ++j;
        }
        this.log("Created " + nodeCount + " nodes for " + j + " examples.");
        return problem;
    }

    private svm_parameter getParameters(ExampleSet exampleSet) throws OperatorException {
        Attribute label;
        svm_parameter params = new svm_parameter();
        params.svm_type = this.getParameterAsInt(PARAMETER_SVM_TYPE);
        params.kernel_type = this.getParameterAsInt(PARAMETER_KERNEL_TYPE);
        params.degree = this.getParameterAsInt(PARAMETER_DEGREE);
        params.gamma = this.getParameterAsDouble(PARAMETER_GAMMA);
        if (params.gamma == 0.0) {
            params.gamma = 1.0 / (double)exampleSet.size();
        }
        params.coef0 = this.getParameterAsDouble(PARAMETER_COEF0);
        params.nu = this.getParameterAsDouble(PARAMETER_NU);
        params.cache_size = this.getParameterAsInt(PARAMETER_CACHE_SIZE);
        params.C = this.getParameterAsDouble(PARAMETER_C);
        params.eps = this.getParameterAsDouble(PARAMETER_EPSILON);
        params.p = this.getParameterAsDouble(PARAMETER_P);
        int n = params.shrinking = this.getParameterAsBoolean(PARAMETER_SHRINKING) ? 1 : 0;
        if (this.getParameterAsBoolean(PARAMETER_CALCULATE_CONFIDENCES)) {
            params.probability = 1;
        }
        if (params.svm_type == 0 && (label = exampleSet.getAttributes().getLabel()).isNominal() && this.isParameterSet(PARAMETER_CLASS_WEIGHTS)) {
            double[] weights = new double[label.getMapping().size()];
            int[] weightLabelIndices = new int[label.getMapping().size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = 1.0;
                weightLabelIndices[i] = i;
            }
            List<String[]> classWeights = this.getParameterList(PARAMETER_CLASS_WEIGHTS);
            for (String[] classWeightArray : classWeights) {
                String className = classWeightArray[0];
                double classWeight = Double.valueOf(classWeightArray[1]);
                int index = label.getMapping().getIndex(className);
                if (index < 0 || index >= weights.length) continue;
                weights[index] = classWeight;
            }
            LinkedList<Double> weightList = new LinkedList<Double>();
            for (double d : weights) {
                weightList.add(d);
            }
            this.log(this.getName() + ": used class weights --> " + weightList);
            params.weight = weights;
            params.nr_weight = weights.length;
            params.weight_label = weightLabelIndices;
        }
        return params;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        svm_problem problem;
        String errorMsg;
        svm_parameter params = this.getParameters(exampleSet);
        if (exampleSet.size() < 2) {
            throw new UserError((Operator)this, 110, 2);
        }
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal()) {
            if (params.svm_type != 0 && params.svm_type != 1 && params.svm_type != 2) {
                throw new UserError((Operator)this, 102, SVM_TYPES[params.svm_type], label.getName());
            }
            if (params.svm_type == 2 && label.getMapping().size() > 1) {
                throw new UserError((Operator)this, 118, label.getName(), label.getMapping().size() + "", "1 for one-class svm");
            }
        } else if (params.svm_type != 3 && params.svm_type != 4) {
            throw new UserError((Operator)this, 101, SVM_TYPES[params.svm_type], label.getName());
        }
        if ((errorMsg = Svm.svm_check_parameter(problem = this.getProblem(exampleSet), params)) != null) {
            throw new UserError((Operator)this, 905, "libsvm", errorMsg);
        }
        this.log("Training LibSVM.");
        svm_model model = Svm.svm_train(problem, params);
        return new LibSVMModel(exampleSet, model, exampleSet.getAttributes().size(), this.getParameterAsBoolean(PARAMETER_CONFIDENCE_FOR_MULTICLASS));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_SVM_TYPE, "SVM for classification (C-SVC, nu-SVC), regression (epsilon-SVR, nu-SVR) and distribution estimation (one-class)", SVM_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_KERNEL_TYPE, "The type of the kernel functions", KERNEL_TYPES, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_DEGREE, "The degree for a polynomial kernel function.", 1, Integer.MAX_VALUE, 3, false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 1));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_GAMMA, "The parameter gamma for polynomial, rbf, and sigmoid kernel functions (0 means 1/#examples).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 1, 2, 3));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_COEF0, "The parameter coef0 for polynomial and sigmoid kernel functions.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 1, 4));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_C, "The cost parameter C for c_svc, epsilon_svr, and nu_svr.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SVM_TYPE, SVM_TYPES, false, 0, 3, 4));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_NU, "The parameter nu for nu_svc, one_class, and nu_svr.", 0.0, 0.5, 0.5);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SVM_TYPE, SVM_TYPES, false, 1, 2, 4));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_CACHE_SIZE, "Cache size in Megabyte.", 0, Integer.MAX_VALUE, 80));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Tolerance of termination criterion.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.001));
        type = new ParameterTypeDouble(PARAMETER_P, "Tolerance of loss function of epsilon-SVR.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SVM_TYPE, SVM_TYPES, false, 3));
        types.add(type);
        types.add(new ParameterTypeList(PARAMETER_CLASS_WEIGHTS, "The weights w for all classes (first column: class name, second column: weight), i.e. set the parameters C of each class w * C (empty: using 1 for all classes where the weight was not defined).", (ParameterType)new ParameterTypeString("class_name", "The class name."), (ParameterType)new ParameterTypeDouble("weight", "The weight for this class.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        types.add(new ParameterTypeBoolean(PARAMETER_SHRINKING, "Whether to use the shrinking heuristics.", true));
        type = new ParameterTypeBoolean(PARAMETER_CALCULATE_CONFIDENCES, "Indicates if proper confidence values should be calculated.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_CONFIDENCE_FOR_MULTICLASS, "Indicates if the class with the highest confidence should be selected in the multiclass setting. Uses binary majority vote over all 1-vs-1 classifiers otherwise (selected class must not be the one with highest confidence in that case).", true));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), LibSVMLearner.class, null);
    }
}

