/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;

public abstract class KernelModel
extends PredictionModel {
    private static final long serialVersionUID = 7480153570564620067L;
    private String[] attributeConstructions;

    public KernelModel(ExampleSet exampleSet) {
        super(exampleSet);
        this.attributeConstructions = Tools.getRegularAttributeConstructions(exampleSet);
    }

    public abstract double getBias();

    public abstract double getAlpha(int var1);

    public abstract double getFunctionValue(int var1);

    public abstract boolean isClassificationModel();

    public abstract String getClassificationLabel(int var1);

    public abstract double getRegressionLabel(int var1);

    public abstract String getId(int var1);

    public abstract SupportVector getSupportVector(int var1);

    public abstract int getNumberOfSupportVectors();

    public abstract int getNumberOfAttributes();

    public abstract double getAttributeValue(int var1, int var2);

    public String[] getAttributeConstructions() {
        return this.attributeConstructions;
    }

    @Override
    public String getName() {
        return "Kernel Model";
    }

    @Override
    public String toString() {
        String[] attributeNames = Tools.getRegularAttributeNames(this.getTrainingHeader());
        StringBuffer result = new StringBuffer();
        result.append("Total number of Support Vectors: " + this.getNumberOfSupportVectors() + com.rapidminer.tools.Tools.getLineSeparator());
        result.append("Bias (offset): " + com.rapidminer.tools.Tools.formatNumber(this.getBias()) + com.rapidminer.tools.Tools.getLineSeparators(2));
        if (!this.getLabel().isNominal() || this.getLabel().getMapping().size() == 2) {
            double[] w = new double[this.getNumberOfAttributes()];
            boolean showWeights = true;
            for (int i = 0; i < this.getNumberOfSupportVectors(); ++i) {
                SupportVector sv = this.getSupportVector(i);
                if (sv != null) {
                    double[] x = sv.getX();
                    double alpha = sv.getAlpha();
                    double y = sv.getY();
                    for (int j = 0; j < w.length; ++j) {
                        int n = j;
                        w[n] = w[n] + y * alpha * x[j];
                    }
                    continue;
                }
                showWeights = false;
            }
            if (showWeights) {
                for (int j = 0; j < w.length; ++j) {
                    result.append("w[" + attributeNames[j] + (!attributeNames[j].equals(this.attributeConstructions[j]) ? " = " + this.attributeConstructions[j] : "") + "] = " + com.rapidminer.tools.Tools.formatNumber(w[j]) + com.rapidminer.tools.Tools.getLineSeparator());
                }
            }
        } else {
            result.append("Feature weight calculation only possible for two class learning problems." + com.rapidminer.tools.Tools.getLineSeparator() + "Please use the operator SVMWeighting instead." + com.rapidminer.tools.Tools.getLineSeparator());
        }
        return result.toString();
    }

    public DataTable createWeightsTable() {
        String[] attributeNames = Tools.getRegularAttributeNames(this.getTrainingHeader());
        SimpleDataTable weightTable = new SimpleDataTable("Kernel Model Weights", new String[]{"Attribute", "Weight"});
        if (!this.getLabel().isNominal() || this.getLabel().getMapping().size() == 2) {
            double[] w = new double[this.getNumberOfAttributes()];
            boolean showWeights = true;
            for (int i = 0; i < this.getNumberOfSupportVectors(); ++i) {
                SupportVector sv = this.getSupportVector(i);
                if (sv != null) {
                    double[] x = sv.getX();
                    double alpha = sv.getAlpha();
                    double y = sv.getY();
                    for (int j = 0; j < w.length; ++j) {
                        int n = j;
                        w[n] = w[n] + y * alpha * x[j];
                    }
                    continue;
                }
                showWeights = false;
            }
            if (showWeights) {
                for (int j = 0; j < w.length; ++j) {
                    int nameIndex = weightTable.mapString(0, attributeNames[j]);
                    weightTable.add(new SimpleDataTableRow(new double[]{nameIndex, w[j]}));
                }
                return weightTable;
            }
            return null;
        }
        return null;
    }
}

