/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.functions.kernel.KernelLogisticRegressionModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import java.util.ArrayList;
import java.util.Iterator;

public class KernelLogisticRegressionOptimization
extends ESOptimization {
    private static final double IS_ZERO = 1.0E-8;
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double[] ys;
    private double c;
    private Attribute label;
    private Attribute weight;
    private boolean multiobjective = false;

    public KernelLogisticRegressionOptimization(ExampleSet exampleSet, Kernel kernel, double c, int initType, int maxIterations, int generationsWithoutImprovement, int popSize, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showConvergencePlot, RandomGenerator random, LoggingHandler logging) {
        super(0.0, 1.0, popSize, exampleSet.size(), initType, maxIterations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, crossoverProb, showConvergencePlot, false, random, logging);
        this.multiobjective = selectionType == 7;
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.kernel.init(this.exampleSet);
        this.c = c;
        this.label = exampleSet.getAttributes().getLabel();
        this.weight = exampleSet.getAttributes().getWeight();
        this.ys = new double[exampleSet.size()];
        int counter = 0;
        for (Example e : exampleSet) {
            this.ys[counter++] = e.getLabel() == (double)this.label.getMapping().getPositiveIndex() ? 1.0 : 0.0;
        }
    }

    @Override
    public PerformanceVector evaluateIndividual(Individual individual) {
        double[] alphas = individual.getValues();
        double marginSum = 0.0;
        for (int i = 0; i < this.ys.length; ++i) {
            if (alphas[i] == 0.0) continue;
            for (int j = 0; j < this.ys.length; ++j) {
                if (alphas[j] == 0.0) continue;
                marginSum += alphas[i] * alphas[j] * this.ys[i] * this.ys[j] * this.kernel.getDistance(i, j);
            }
        }
        double errorSum = 0.0;
        int i = 0;
        for (Example example : this.exampleSet) {
            double delta = alphas[i];
            if (!this.multiobjective) {
                delta /= this.c;
            }
            if (delta > 0.0) {
                double currentResult;
                double weightValue = 1.0;
                if (this.weight != null) {
                    weightValue = example.getValue(this.weight);
                }
                if (!Double.isNaN(currentResult = weightValue * (delta * Math.log(delta) + (1.0 - delta) * Math.log(1.0 - delta)))) {
                    errorSum += currentResult;
                }
            }
            ++i;
        }
        PerformanceVector performanceVector = new PerformanceVector();
        if (!this.multiobjective) {
            double fitness = marginSum + this.c * errorSum;
            performanceVector.addCriterion(new EstimatedPerformance("log_reg_fitness", fitness, 1, false));
        } else {
            performanceVector.addCriterion(new EstimatedPerformance("log_reg_margin", marginSum, 1, false));
            performanceVector.addCriterion(new EstimatedPerformance("log_reg_error", errorSum, 1, false));
        }
        return performanceVector;
    }

    public Model train() throws OperatorException {
        this.optimize();
        return this.getModel(this.getBestValuesEver());
    }

    private Model getModel(double[] alphas) {
        int i;
        Iterator reader = this.exampleSet.iterator();
        ArrayList<SupportVector> supportVectors = new ArrayList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = (Example)reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getAttributes().size()];
                int a = 0;
                for (Attribute attribute : this.exampleSet.getAttributes()) {
                    x[a++] = currentExample.getValue(attribute);
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.size()];
        reader = this.exampleSet.iterator();
        index = 0;
        while (reader.hasNext()) {
            Example current = (Example)reader.next();
            double[] x = new double[this.exampleSet.getAttributes().size()];
            int a = 0;
            for (Attribute attribute : this.exampleSet.getAttributes()) {
                x[a++] = current.getValue(attribute);
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        int bCounter = 0;
        for (i = 0; i < alphas.length; ++i) {
            if (this.ys[i] * alphas[i] - this.c < -1.0E-8 && this.ys[i] * alphas[i] > 1.0E-8) {
                bSum += this.ys[i] - sum[i];
                ++bCounter;
                continue;
            }
            if (!(this.ys[i] * alphas[i] + this.c > 1.0E-8) || !(this.ys[i] * alphas[i] < -1.0E-8)) continue;
            bSum += this.ys[i] - sum[i];
            ++bCounter;
        }
        if (bCounter == 0) {
            bSum = 0.0;
            for (i = 0; i < alphas.length; ++i) {
                if (!(this.ys[i] * alphas[i] < 1.0E-8) || !(this.ys[i] * alphas[i] > -1.0E-8)) continue;
                bSum += this.ys[i] - sum[i];
                ++bCounter;
            }
            if (bCounter == 0) {
                bSum = 0.0;
                for (i = 0; i < alphas.length; ++i) {
                    bSum += this.ys[i] - sum[i];
                    ++bCounter;
                }
            }
        }
        return new KernelLogisticRegressionModel(this.exampleSet, supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

