/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMLearner;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.JMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMpattern;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMregression;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class JMySVMLearner
extends AbstractMySVMLearner {
    public static final String PARAMETER_ESTIMATE_PERFORMANCE = "estimate_performance";
    public static final String PARAMETER_L_POS = "L_pos";
    public static final String PARAMETER_L_NEG = "L_neg";
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_EPSILON_PLUS = "epsilon_plus";
    public static final String PARAMETER_EPSILON_MINUS = "epsilon_minus";
    public static final String PARAMETER_BALANCE_COST = "balance_cost";
    public static final String PARAMETER_QUADRATIC_LOSS_POS = "quadratic_loss_pos";
    public static final String PARAMETER_QUADRATIC_LOSS_NEG = "quadratic_loss_neg";
    private boolean pattern = true;

    public JMySVMLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return this.getParameterAsBoolean(PARAMETER_ESTIMATE_PERFORMANCE);
    }

    @Override
    public boolean canEstimatePerformance() {
        return true;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        if (!this.pattern) {
            throw new UserError((Operator)this, 912, this, "Cannot calculate leave one out estimation of error for regression tasks!");
        }
        double[] estVector = ((SVMpattern)this.getSVM()).getXiAlphaEstimation(this.getKernel());
        PerformanceVector pv = new PerformanceVector();
        pv.addCriterion(new EstimatedPerformance("xialpha_error", estVector[0], 1, true));
        pv.addCriterion(new EstimatedPerformance("xialpha_precision", estVector[1], 1, false));
        pv.addCriterion(new EstimatedPerformance("xialpha_recall", estVector[2], 1, false));
        pv.setMainCriterionName("xialpha_error");
        return pv;
    }

    @Override
    public AbstractMySVMModel createSVMModel(ExampleSet exampleSet, SVMExamples sVMExamples, Kernel kernel, int kernelType) {
        return new JMySVMModel(exampleSet, sVMExamples, kernel, kernelType);
    }

    @Override
    public SVMInterface createSVM(Attribute label, Kernel kernel, SVMExamples sVMExamples, ExampleSet rapidMinerExamples) throws OperatorException {
        if (label.isNominal()) {
            this.pattern = true;
            return new SVMpattern(this, kernel, sVMExamples, rapidMinerExamples, RandomGenerator.getGlobalRandomGenerator());
        }
        this.pattern = false;
        return new SVMregression(this, kernel, sVMExamples, rapidMinerExamples, RandomGenerator.getGlobalRandomGenerator());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_L_POS, "A factor for the SVM complexity constant for positive examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_L_NEG, "A factor for the SVM complexity constant for negative examples", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Insensitivity constant. No loss if prediction lies this close to true value", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON_PLUS, "Epsilon for positive deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON_MINUS, "Epsilon for negative deviation only", 0.0, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeBoolean(PARAMETER_BALANCE_COST, "Adapts Cpos and Cneg to the relative size of the classes", false));
        types.add(new ParameterTypeBoolean(PARAMETER_QUADRATIC_LOSS_POS, "Use quadratic loss for positive deviation", false));
        types.add(new ParameterTypeBoolean(PARAMETER_QUADRATIC_LOSS_NEG, "Use quadratic loss for negative deviation", false));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ESTIMATE_PERFORMANCE, "Indicates if this learner should also return a performance estimation.", false);
        type.setDeprecated();
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), JMySVMLearner.class, null);
    }
}

