/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.GPModel;
import com.rapidminer.operator.learner.functions.kernel.RVMModel;
import com.rapidminer.operator.learner.functions.kernel.gaussianprocess.Parameter;
import com.rapidminer.operator.learner.functions.kernel.gaussianprocess.Regression;
import com.rapidminer.operator.learner.functions.kernel.gaussianprocess.RegressionProblem;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelCauchy;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelEpanechnikov;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelGaussianCombination;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelLaplace;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelMultiquadric;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelPoly;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelRadial;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelSigmoid;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Iterator;
import java.util.List;

public class GPLearner
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_GP_TYPE = "gp_type";
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_KERNEL_LENGTHSCALE = "kernel_lengthscale";
    public static final String PARAMETER_KERNEL_DEGREE = "kernel_degree";
    public static final String PARAMETER_KERNEL_BIAS = "kernel_bias";
    public static final String PARAMETER_KERNEL_SIGMA1 = "kernel_sigma1";
    public static final String PARAMETER_KERNEL_SIGMA2 = "kernel_sigma2";
    public static final String PARAMETER_KERNEL_SIGMA3 = "kernel_sigma3";
    public static final String PARAMETER_KERNEL_SHIFT = "kernel_shift";
    public static final String PARAMETER_KERNEL_A = "kernel_a";
    public static final String PARAMETER_KERNEL_B = "kernel_b";
    public static final String PARAMETER_MAX_BASIS_VECTORS = "max_basis_vectors";
    public static final String PARAMETER_EPSILON_TOL = "epsilon_tol";
    public static final String PARAMETER_GEOMETRICAL_TOL = "geometrical_tol";
    public static final String[] KERNEL_TYPES = new String[]{"rbf", "cauchy", "laplace", "poly", "sigmoid", "Epanechnikov", "gaussian combination", "multiquadric"};

    public GPLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return lc == OperatorCapability.NUMERICAL_LABEL;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.log("Creating GP-Learner.");
        Parameter parameter = new Parameter();
        int numExamples = exampleSet.size();
        parameter.maxBasisVectors = this.getParameterAsInt(PARAMETER_MAX_BASIS_VECTORS);
        parameter.epsilon_tol = this.getParameterAsDouble(PARAMETER_EPSILON_TOL);
        parameter.geometrical_tol = this.getParameterAsDouble(PARAMETER_GEOMETRICAL_TOL);
        this.log("Creating input / output vectors.");
        double[][] x = new double[numExamples][exampleSet.getAttributes().size()];
        double[][] t = new double[numExamples][1];
        Iterator reader = exampleSet.iterator();
        int k = 0;
        while (reader.hasNext()) {
            double[] targetVector = new double[1];
            Example e = (Example)reader.next();
            targetVector[0] = e.getLabel();
            x[k] = RVMModel.makeInputVector(e);
            t[k] = targetVector;
            ++k;
        }
        Attribute label = exampleSet.getAttributes().getLabel();
        this.log("Creating kernel.");
        Kernel kernel = this.createKernel();
        com.rapidminer.operator.learner.functions.kernel.gaussianprocess.Model model = null;
        if (label.isNominal()) {
            throw new UserError((Operator)this, 102, this.getName(), label.getName());
        }
        RegressionProblem problem = new RegressionProblem(x, t, kernel);
        Regression GP = new Regression(problem, parameter);
        try {
            model = GP.learn();
        }
        catch (Exception e) {
            throw new OperatorException(e.getMessage());
        }
        return new GPModel(exampleSet, model);
    }

    public Kernel createKernel() throws OperatorException {
        Kernel kernel = null;
        double lengthScale = this.getParameterAsDouble(PARAMETER_KERNEL_LENGTHSCALE);
        double bias = this.getParameterAsDouble(PARAMETER_KERNEL_BIAS);
        double degree = this.getParameterAsDouble(PARAMETER_KERNEL_DEGREE);
        double a = this.getParameterAsDouble(PARAMETER_KERNEL_A);
        double b = this.getParameterAsDouble(PARAMETER_KERNEL_B);
        double sigma1 = this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1);
        double sigma2 = this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA2);
        double sigma3 = this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA3);
        double shift = this.getParameterAsDouble(PARAMETER_KERNEL_SHIFT);
        switch (this.getParameterAsInt(PARAMETER_KERNEL_TYPE)) {
            case 0: {
                kernel = new KernelRadial(lengthScale);
                break;
            }
            case 1: {
                kernel = new KernelCauchy(lengthScale);
                break;
            }
            case 2: {
                kernel = new KernelLaplace(lengthScale);
                break;
            }
            case 3: {
                kernel = new KernelPoly(lengthScale, bias, degree);
                break;
            }
            case 4: {
                kernel = new KernelSigmoid(a, b);
                break;
            }
            case 5: {
                kernel = new KernelEpanechnikov(sigma1, degree);
                break;
            }
            case 6: {
                kernel = new KernelGaussianCombination(sigma1, sigma2, sigma3);
                break;
            }
            case 7: {
                kernel = new KernelMultiquadric(sigma1, shift);
                break;
            }
            default: {
                kernel = new KernelRadial(lengthScale);
            }
        }
        return kernel;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_KERNEL_TYPE, "The kind of kernel.", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_LENGTHSCALE, "The lengthscale used in all kernels.", 0.0, Double.POSITIVE_INFINITY, 3.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 0, 1, 2, 3));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_DEGREE, "The degree used in the poly kernel.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 3, 5));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_BIAS, "The bias used in the poly kernel.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 3));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA1, "The SVM kernel parameter sigma1 (Epanechnikov, Gaussian Combination, Multiquadric).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 5, 6, 7));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA2, "The SVM kernel parameter sigma2 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 6));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA3, "The SVM kernel parameter sigma3 (Gaussian Combination).", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 6));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SHIFT, "The SVM kernel parameter shift (Multiquadric).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 7));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_A, "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 4));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_B, "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 4));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_BASIS_VECTORS, "Maximum number of basis vectors to be used.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_EPSILON_TOL, "Tolerance for gamma induced projections", 0.0, Double.POSITIVE_INFINITY, 1.0E-7);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_GEOMETRICAL_TOL, "Tolerance for geometry induced projections", 0.0, Double.POSITIVE_INFINITY, 1.0E-7);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

