/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.functions.kernel.AbstractKernelBasedLearner;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelAnova;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelDot;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelEpanechnikov;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelGaussianCombination;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelMultiquadric;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelNeural;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelPolynomial;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.KernelRadial;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMySVMLearner
extends AbstractKernelBasedLearner {
    public static final String PARAMETER_KERNEL_GAMMA = "kernel_gamma";
    public static final String PARAMETER_KERNEL_SIGMA1 = "kernel_sigma1";
    public static final String PARAMETER_KERNEL_SIGMA2 = "kernel_sigma2";
    public static final String PARAMETER_KERNEL_SIGMA3 = "kernel_sigma3";
    public static final String PARAMETER_KERNEL_SHIFT = "kernel_shift";
    public static final String PARAMETER_KERNEL_DEGREE = "kernel_degree";
    public static final String PARAMETER_KERNEL_A = "kernel_a";
    public static final String PARAMETER_KERNEL_B = "kernel_b";
    public static final String PARAMETER_KERNEL_CACHE = "kernel_cache";
    public static final String PARAMETER_CONVERGENCE_EPSILON = "convergence_epsilon";
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_SCALE = "scale";
    public static final String PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE = "return_optimization_performance";
    public static final String PARAMETER_C = "C";
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_CALCULATE_WEIGHTS = "calculate_weights";
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "neural", "anova", "epachnenikov", "gaussian_combination", "multiquadric"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_NEURAL = 3;
    public static final int KERNEL_ANOVA = 4;
    public static final int KERNEL_EPANECHNIKOV = 5;
    public static final int KERNEL_GAUSSIAN_COMBINATION = 6;
    public static final int KERNEL_MULTIQUADRIC = 7;
    private SVMInterface svm = null;
    private Kernel kernel;
    private SVMExamples svmExamples;

    public AbstractMySVMLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public MetaDataError getWeightCalculationError(OutputPort weightPort) {
        try {
            return new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)weightPort, Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_KERNEL_TYPE, "0", "correct_parameter_settings_by", PARAMETER_KERNEL_TYPE, KERNEL_TYPES[0])), "parameters.setting_incompatible_for_delivering", "AttributeWeights", PARAMETER_KERNEL_TYPE, KERNEL_TYPES[this.getParameterAsInt(PARAMETER_KERNEL_TYPE)]);
        }
        catch (UndefinedParameterError e) {
            return super.getWeightCalculationError(weightPort);
        }
    }

    public abstract SVMInterface createSVM(Attribute var1, Kernel var2, SVMExamples var3, ExampleSet var4) throws OperatorException;

    public abstract AbstractMySVMModel createSVMModel(ExampleSet var1, SVMExamples var2, Kernel var3, int var4);

    protected Kernel getKernel() {
        return this.kernel;
    }

    protected SVMInterface getSVM() {
        return this.svm;
    }

    @Override
    public boolean shouldDeliverOptimizationPerformance() {
        return this.getParameterAsBoolean(PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE);
    }

    @Override
    public PerformanceVector getOptimizationPerformance() {
        double finalFitness = this.getFitness(this.svmExamples.get_alphas(), this.svmExamples.get_ys(), this.kernel);
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("svm_objective_function", finalFitness, 1, false));
        result.addCriterion(new EstimatedPerformance("no_support_vectors", this.svmExamples.getNumberOfSupportVectors(), 1, true));
        return result;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return this.getParameterAsBoolean(PARAMETER_CALCULATE_WEIGHTS);
    }

    @Override
    public boolean canCalculateWeights() {
        try {
            return this.getParameterAsInt(PARAMETER_KERNEL_TYPE) == 0;
        }
        catch (UndefinedParameterError e) {
            return false;
        }
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        if (this.getParameterAsInt(PARAMETER_KERNEL_TYPE) != 0) {
            throw new UserError((Operator)this, 916, this, "Cannot create weights for nonlinear kernel!");
        }
        double[] weights = this.svm.getWeights();
        AttributeWeights weightVector = new AttributeWeights();
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            weightVector.setWeight(attribute.getName(), weights[i++]);
        }
        return weightVector;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.isNominal() && label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, this.getName(), label.getName());
        }
        this.svmExamples = new SVMExamples(exampleSet, label, this.getParameterAsBoolean(PARAMETER_SCALE));
        int cacheSize = this.getParameterAsInt(PARAMETER_KERNEL_CACHE);
        int kernelType = this.getParameterAsInt(PARAMETER_KERNEL_TYPE);
        this.kernel = AbstractMySVMLearner.createKernel(kernelType);
        if (kernelType == 1) {
            ((KernelRadial)this.kernel).setGamma(this.getParameterAsDouble(PARAMETER_KERNEL_GAMMA));
        } else if (kernelType == 2) {
            ((KernelPolynomial)this.kernel).setDegree(this.getParameterAsDouble(PARAMETER_KERNEL_DEGREE));
        } else if (kernelType == 3) {
            ((KernelNeural)this.kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_A), this.getParameterAsDouble(PARAMETER_KERNEL_B));
        } else if (kernelType == 4) {
            ((KernelAnova)this.kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_GAMMA), this.getParameterAsDouble(PARAMETER_KERNEL_DEGREE));
        } else if (kernelType == 5) {
            ((KernelEpanechnikov)this.kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNEL_DEGREE));
        } else if (kernelType == 6) {
            ((KernelGaussianCombination)this.kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA2), this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA3));
        } else if (kernelType == 7) {
            ((KernelMultiquadric)this.kernel).setParameters(this.getParameterAsDouble(PARAMETER_KERNEL_SIGMA1), this.getParameterAsDouble(PARAMETER_KERNEL_SHIFT));
        }
        this.kernel.init(this.svmExamples, cacheSize);
        this.svm = this.createSVM(label, this.kernel, this.svmExamples, exampleSet);
        this.svm.init(this.kernel, this.svmExamples);
        this.svm.train();
        return this.createSVMModel(exampleSet, this.svmExamples, this.kernel, kernelType);
    }

    private double getFitness(double[] alphas, double[] ys, Kernel kernel) {
        double sum = 0.0;
        int numberSV = 0;
        for (int i = 0; i < ys.length; ++i) {
            sum += alphas[i];
            if (!(alphas[i] > 0.0)) continue;
            ++numberSV;
        }
        double matrixSum = 0.0;
        for (int i = 0; i < ys.length; ++i) {
            if (alphas[i] == 0.0) continue;
            for (int j = 0; j < ys.length; ++j) {
                if (alphas[j] == 0.0) continue;
                matrixSum += alphas[i] * alphas[j] * ys[i] * ys[j] * kernel.calculate_K(i, j);
            }
        }
        return sum - 0.5 * matrixSum;
    }

    public static Kernel createKernel(int kernelType) {
        switch (kernelType) {
            case 0: {
                return new KernelDot();
            }
            case 1: {
                return new KernelRadial();
            }
            case 2: {
                return new KernelPolynomial();
            }
            case 3: {
                return new KernelNeural();
            }
            case 4: {
                return new KernelAnova();
            }
            case 5: {
                return new KernelEpanechnikov();
            }
            case 6: {
                return new KernelGaussianCombination();
            }
            case 7: {
                return new KernelMultiquadric();
            }
        }
        return new KernelDot();
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.NUMERICAL_LABEL) {
            return true;
        }
        if (lc == OperatorCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return lc == OperatorCapability.FORMULA_PROVIDER;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_KERNEL_TYPE, "The SVM kernel type", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_GAMMA, "The SVM kernel parameter gamma.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 1, 4));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA1, "The SVM kernel parameter sigma1.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 5, 6, 7));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA2, "The SVM kernel parameter sigma2.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 6));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SIGMA3, "The SVM kernel parameter sigma3.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 6));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_SHIFT, "The SVM kernel parameter shift.", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 7));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_DEGREE, "The SVM kernel parameter degree.", 0.0, Double.POSITIVE_INFINITY, 2.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 2, 4, 5));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_A, "The SVM kernel parameter a.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 3));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_KERNEL_B, "The SVM kernel parameter b.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_KERNEL_TYPE, KERNEL_TYPES, false, 3));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_KERNEL_CACHE, "Size of the cache for kernel evaluations im MB ", 0, Integer.MAX_VALUE, 200));
        type = new ParameterTypeDouble(PARAMETER_C, "The SVM complexity constant. Use -1 for different C values for positive and negative.", -1.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_CONVERGENCE_EPSILON, "Precision on the KKT conditions", 0.0, Double.POSITIVE_INFINITY, 0.001);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "Stop after this many iterations", 1, Integer.MAX_VALUE, 100000));
        types.add(new ParameterTypeBoolean(PARAMETER_SCALE, "Scale the example values and store the scaling parameters for test set.", true));
        type = new ParameterTypeBoolean(PARAMETER_CALCULATE_WEIGHTS, "Indicates if attribute weights should be returned.", true);
        type.setDeprecated();
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_RETURN_OPTIMIZATION_PERFORMANCE, "Indicates if final optimization fitness should be returned as performance.", true);
        type.setDeprecated();
        types.add(type);
        return types;
    }
}

