/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;

public class VectorRegressionModel
extends PredictionModel {
    private static final long serialVersionUID = 8381268071090932037L;
    private String[] labelNames;
    private String[] attributeNames;
    Matrix coefficients;
    private boolean useIntercept = true;

    public VectorRegressionModel(ExampleSet exampleSet, String[] labelNames, Matrix coefficients, boolean useIntercept) {
        super(exampleSet);
        this.labelNames = labelNames;
        this.attributeNames = Tools.getRegularAttributeNames(exampleSet);
        this.coefficients = coefficients;
        this.useIntercept = useIntercept;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) {
        Attribute[] predictedLabels = new Attribute[this.labelNames.length];
        for (int i = 0; i < this.labelNames.length; ++i) {
            predictedLabels[i] = AttributeFactory.createAttribute("prediction(" + this.labelNames[i] + ")", 2);
            exampleSet.getExampleTable().addAttribute(predictedLabels[i]);
            exampleSet.getAttributes().addRegular(predictedLabels[i]);
            exampleSet.getAttributes().setSpecialAttribute(predictedLabels[i], "prediction_" + this.labelNames[i]);
        }
        Attributes attributes = exampleSet.getAttributes();
        Attribute[] usedAttributes = new Attribute[this.attributeNames.length];
        for (int i = 0; i < this.attributeNames.length; ++i) {
            usedAttributes[i] = attributes.get(this.attributeNames[i]);
        }
        for (Example example : exampleSet) {
            for (int i = 0; i < predictedLabels.length; ++i) {
                int j;
                double predictedLabel;
                double d = predictedLabel = this.useIntercept ? this.coefficients.get(0, i) : 0.0;
                if (this.useIntercept) {
                    for (j = 1; j <= this.attributeNames.length; ++j) {
                        predictedLabel += example.getValue(usedAttributes[j - 1]) * this.coefficients.get(j, i);
                    }
                } else {
                    for (j = 0; j < this.attributeNames.length; ++j) {
                        predictedLabel += example.getValue(usedAttributes[j]) * this.coefficients.get(j, i);
                    }
                }
                example.setValue(predictedLabels[i], predictedLabel);
            }
        }
        return exampleSet;
    }

    public String[] getLabelNames() {
        return this.labelNames;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public double[] getCoefficients(String labelName) {
        double[] coefficients = new double[this.coefficients.getRowDimension()];
        int i = 0;
        for (String label : this.labelNames) {
            if (label.equals(labelName)) {
                for (int j = 0; j < coefficients.length - 1; ++j) {
                    coefficients[j] = this.coefficients.get(j + 1, i);
                }
                coefficients[coefficients.length - 1] = this.coefficients.get(0, i);
                return coefficients;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.labelNames.length; ++i) {
            result.append(this.labelNames[i] + " = ");
            boolean first = true;
            for (int j = this.useIntercept ? 1 : 0; j < this.attributeNames.length + (this.useIntercept ? 1 : 0); ++j) {
                result.append(this.getCoefficientString(this.coefficients.get(j, i), first) + " * " + this.attributeNames[j - (this.useIntercept ? 1 : 0)] + "  ");
                first = false;
            }
            if (this.useIntercept) {
                result.append(this.getCoefficientString(this.coefficients.get(0, i), false));
            }
            result.append("\n");
        }
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        return null;
    }
}

