/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.functions.LinearRegression;
import com.rapidminer.operator.learner.functions.LinearRegressionModel;
import com.rapidminer.operator.learner.functions.SeeminglyUnrelatedRegressionModel;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SeeminglyUnrelatedRegressionOperator
extends AbstractLearner {
    private InputPortExtender unrelatedExampleSets = new InputPortExtender("unrelated example sets", this.getInputPorts());

    public SeeminglyUnrelatedRegressionOperator(OperatorDescription description) {
        super(description);
        this.unrelatedExampleSets.start();
    }

    @Override
    public Model learn(ExampleSet mainSet) throws OperatorException {
        List<ExampleSet> dataSets = this.unrelatedExampleSets.getData(true);
        return this.learn(mainSet, dataSets);
    }

    public SeeminglyUnrelatedRegressionModel learn(ExampleSet mainSet, List<ExampleSet> dataSets) throws UserError, UndefinedParameterError, OperatorException, ProcessStoppedException {
        int numberOfExamples = mainSet.size();
        int numberOfSets = dataSets.size();
        for (ExampleSet exampleSet : dataSets) {
            if (exampleSet.size() == numberOfExamples) continue;
            throw new UserError((Operator)this, 951);
        }
        Attributes mainAttributes = mainSet.getAttributes();
        int exampleSetIndex = 1;
        for (ExampleSet testSet : dataSets) {
            Attributes attributes = testSet.getAttributes();
            for (Attribute attribute : attributes) {
                if (mainAttributes.get(attribute.getName()) != null) continue;
                throw new UserError((Operator)this, 952, attribute.getName(), exampleSetIndex + "");
            }
            ++exampleSetIndex;
        }
        ArrayList<ExampleSet> residualSets = new ArrayList<ExampleSet>(dataSets.size());
        ArrayList<Pair<Attribute, Attribute>> labelPredictionAttributes = new ArrayList<Pair<Attribute, Attribute>>(dataSets.size());
        ArrayList setIterators = new ArrayList(dataSets.size());
        ArrayList<String[]> usedAttributeNames = new ArrayList<String[]>(dataSets.size());
        ArrayList<String> labelNames = new ArrayList<String>(dataSets.size());
        try {
            LinearRegression regression = OperatorService.createOperator(LinearRegression.class);
            regression.setParameter("eliminate_colinear_features", this.getParameterAsString("eliminate_colinear_features"));
            regression.setParameter("feature_selection", this.getParameterAsString("feature_selection"));
            regression.setParameter("min_standardized_coefficient", this.getParameterAsString("min_standardized_coefficient"));
            regression.setParameter("ridge", this.getParameterAsString("ridge"));
            regression.setParameter("use_bias", "true");
            for (ExampleSet exampleSet : dataSets) {
                LinearRegressionModel model = (LinearRegressionModel)regression.learn(exampleSet);
                ExampleSet resultSet = model.apply(exampleSet);
                residualSets.add(resultSet);
                Attribute label = resultSet.getAttributes().getLabel();
                labelPredictionAttributes.add(new Pair<Attribute, Attribute>(label, resultSet.getAttributes().getPredictedLabel()));
                labelNames.add(label.getName());
                usedAttributeNames.add(model.getSelectedAttributeNames());
                setIterators.add(resultSet.iterator());
            }
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 950, LinearRegression.class.getSimpleName(), e.getMessage());
        }
        this.checkForStop();
        double[][] residualMatrix = new double[numberOfExamples][numberOfSets];
        for (int i = 0; i < numberOfExamples; ++i) {
            for (int j = 0; j < numberOfSets; ++j) {
                Example example = (Example)((Iterator)setIterators.get(j)).next();
                Pair labelPredictionPair = (Pair)labelPredictionAttributes.get(j);
                residualMatrix[i][j] = example.getValue((Attribute)labelPredictionPair.getFirst()) - example.getValue((Attribute)labelPredictionPair.getSecond());
            }
        }
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(residualMatrix);
        Matrix wMatrixInverse = new Matrix(numberOfSets * numberOfExamples, numberOfSets * numberOfExamples, 0.0);
        for (int i = 0; i < numberOfSets; ++i) {
            for (int j = 0; j < numberOfSets; ++j) {
                Matrix partlyResult = Matrix.identity((int)numberOfExamples, (int)numberOfExamples).times(covarianceMatrix.get(i, j));
                wMatrixInverse.setMatrix(i * numberOfExamples, (i + 1) * numberOfExamples - 1, j * numberOfExamples, (j + 1) * numberOfExamples - 1, partlyResult);
            }
        }
        this.checkForStop();
        wMatrixInverse = wMatrixInverse.times(1.0 / (double)numberOfExamples);
        wMatrixInverse = wMatrixInverse.inverse();
        this.checkForStop();
        int width = 0;
        for (String[] selectedAttributes : usedAttributeNames) {
            width += selectedAttributes.length + 1;
        }
        int height = numberOfSets * numberOfExamples;
        Matrix xMatrix = new Matrix(height, width, 0.0);
        int i = 0;
        int currentColumn = 0;
        for (ExampleSet unrelatedSet : dataSets) {
            this.checkForStop();
            Attributes attributes = unrelatedSet.getAttributes();
            Attribute[] selectedAttributes = new Attribute[((String[])usedAttributeNames.get(i)).length];
            int j = 0;
            for (String selectedAttributeName : (String[])usedAttributeNames.get(i)) {
                selectedAttributes[j] = attributes.get(selectedAttributeName);
                ++j;
            }
            double[][] subMatrixData = new double[numberOfExamples][selectedAttributes.length + 1];
            int y = 0;
            for (Example example : unrelatedSet) {
                subMatrixData[y][0] = 1.0;
                int x = 1;
                for (Attribute attribute : selectedAttributes) {
                    subMatrixData[y][x] = example.getValue(attribute);
                    ++x;
                }
                ++y;
            }
            xMatrix.setMatrix(i * numberOfExamples, (i + 1) * numberOfExamples - 1, currentColumn, currentColumn + selectedAttributes.length, new Matrix(subMatrixData));
            currentColumn += selectedAttributes.length + 1;
            ++i;
        }
        double[][] yMatrixData = new double[height][1];
        int currentRow = 0;
        for (ExampleSet unrelatedSet : dataSets) {
            this.checkForStop();
            Attribute label = unrelatedSet.getAttributes().getLabel();
            for (Example example : unrelatedSet) {
                yMatrixData[currentRow][0] = example.getValue(label);
                ++currentRow;
            }
        }
        Matrix yMatrix = new Matrix(yMatrixData);
        this.checkForStop();
        Matrix result = xMatrix.transpose().times(wMatrixInverse);
        this.checkForStop();
        result = result.times(xMatrix).inverse();
        this.checkForStop();
        result = result.times(xMatrix.transpose());
        this.checkForStop();
        result = result.times(wMatrixInverse);
        this.checkForStop();
        result = result.times(yMatrix);
        this.checkForStop();
        return new SeeminglyUnrelatedRegressionModel(mainSet, usedAttributeNames, labelNames, result.getRowPackedCopy());
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc.equals((Object)OperatorCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        return lc.equals((Object)OperatorCapability.NUMERICAL_LABEL);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("feature_selection", "The feature selection method used during regression.", LinearRegression.FEATURE_SELECTION_METHODS, 1));
        types.add(new ParameterTypeBoolean("eliminate_colinear_features", "Indicates if the algorithm should try to delete colinear features during the regression.", true));
        types.add(new ParameterTypeDouble("min_standardized_coefficient", "The minimum standardized coefficient for the removal of colinear feature elimination.", 0.0, Double.POSITIVE_INFINITY, 1.5));
        types.add(new ParameterTypeDouble("ridge", "The ridge parameter used during ridge regression.", 0.0, Double.POSITIVE_INFINITY, 1.0E-8));
        return types;
    }
}

