/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.List;

public class SeeminglyUnrelatedRegressionModel
extends PredictionModel {
    private static final long serialVersionUID = 4843759046775802520L;
    private ArrayList<String[]> usedAttributeNames;
    private ArrayList<String> labelNames;
    private double[] coefficients;

    protected SeeminglyUnrelatedRegressionModel(ExampleSet trainingExampleSet, ArrayList<String[]> usedAttributeNames, ArrayList<String> labelNames, double[] coefficients) {
        super(trainingExampleSet);
        this.usedAttributeNames = usedAttributeNames;
        this.labelNames = labelNames;
        this.coefficients = coefficients;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) {
        Attribute[] predictedLabels = new Attribute[this.labelNames.size()];
        for (int i = 0; i < this.labelNames.size(); ++i) {
            String labelName = this.labelNames.get(i);
            predictedLabels[i] = AttributeFactory.createAttribute("prediction(" + labelName + ")", 4);
            exampleSet.getExampleTable().addAttribute(predictedLabels[i]);
            exampleSet.getAttributes().addRegular(predictedLabels[i]);
            exampleSet.getAttributes().setSpecialAttribute(predictedLabels[i], "prediction_" + labelName);
        }
        Attribute[][] usedAttributes = new Attribute[this.usedAttributeNames.size()][];
        Attributes attributes = exampleSet.getAttributes();
        for (int i = 0; i < this.usedAttributeNames.size(); ++i) {
            String[] currentAttributeNames = this.usedAttributeNames.get(i);
            Attribute[] regressionAttributes = new Attribute[currentAttributeNames.length];
            for (int j = 0; j < currentAttributeNames.length; ++j) {
                regressionAttributes[j] = attributes.get(currentAttributeNames[j]);
            }
            usedAttributes[i] = regressionAttributes;
        }
        for (Example example : exampleSet) {
            int coefficientOffset = 0;
            for (int i = 0; i < predictedLabels.length; ++i) {
                double predictedValue = this.coefficients[coefficientOffset];
                ++coefficientOffset;
                for (int j = 0; j < usedAttributes[i].length; ++j) {
                    predictedValue += example.getValue(usedAttributes[i][j]) * this.coefficients[coefficientOffset + j];
                }
                coefficientOffset += usedAttributes[i].length;
                example.setValue(predictedLabels[i], predictedValue);
            }
        }
        return exampleSet;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        return null;
    }

    public double[] getCoefficients(String labelName) {
        int offset = 0;
        int length = 0;
        int i = 0;
        for (String label : this.labelNames) {
            String[] selectedAttributes = this.usedAttributeNames.get(i);
            length = selectedAttributes.length;
            if (label.equals(labelName)) break;
            offset += 1 + length;
            ++i;
        }
        if (offset < this.coefficients.length) {
            double[] coefficients = new double[length + 1];
            for (int j = 0; j < coefficients.length - 1; ++j) {
                coefficients[j] = this.coefficients[offset + j + 1];
            }
            coefficients[coefficients.length - 1] = this.coefficients[offset];
            return coefficients;
        }
        return null;
    }

    public String[] getSelectedAttributeNames(String labelName) {
        int i = 0;
        for (String label : this.labelNames) {
            if (label.equals(labelName)) {
                return this.usedAttributeNames.get(i);
            }
            ++i;
        }
        return null;
    }

    public List<String> getLabelNames() {
        return this.labelNames;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        int j = 0;
        int coeffIndex = 0;
        for (String labelName : this.labelNames) {
            result.append(Tools.getLineSeparators(2) + labelName + Tools.getLineSeparators(2));
            String[] selectedAttributes = this.usedAttributeNames.get(j);
            result.append(this.getCoefficientString(this.coefficients[coeffIndex], true) + Tools.getLineSeparator());
            ++coeffIndex;
            for (int i = 0; i < selectedAttributes.length; ++i) {
                result.append(this.getCoefficientString(this.coefficients[coeffIndex], false) + " * " + selectedAttributes[i] + Tools.getLineSeparator());
                ++coeffIndex;
            }
            ++j;
        }
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + Tools.formatNumber(Math.abs(coefficient));
    }
}

