/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.PolynomialRegressionModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import java.util.List;

public class PolynomialRegression
extends AbstractLearner {
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_REPLICATION_FACTOR = "replication_factor";
    public static final String PARAMETER_MAX_DEGREE = "max_degree";
    public static final String PARAMETER_MIN_COEFFICIENT = "min_coefficient";
    public static final String PARAMETER_MAX_COEFFICIENT = "max_coefficient";

    public PolynomialRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        RegressionOptimization optimization = new RegressionOptimization(exampleSet, this.getParameterAsInt(PARAMETER_REPLICATION_FACTOR), this.getParameterAsInt(PARAMETER_MAX_ITERATIONS), this.getParameterAsInt(PARAMETER_MAX_DEGREE), this.getParameterAsDouble(PARAMETER_MIN_COEFFICIENT), this.getParameterAsDouble(PARAMETER_MAX_COEFFICIENT), RandomGenerator.getRandomGenerator(this), this);
        optimization.optimize();
        double[] values = optimization.getBestValuesEver();
        double[][] coefficients = optimization.getCoefficients(values);
        double[][] degrees = optimization.getDegrees(values);
        double offset = optimization.getOffset(values);
        return new PolynomialRegressionModel(exampleSet, coefficients, degrees, offset);
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return PolynomialRegressionModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc.equals((Object)OperatorCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        if (lc.equals((Object)OperatorCapability.NUMERICAL_LABEL)) {
            return true;
        }
        return lc == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "The maximum number of iterations used for model fitting.", 1, Integer.MAX_VALUE, 5000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_REPLICATION_FACTOR, "The amount of times each input variable is replicated, i.e. how many different degrees and coefficients can be applied to each variable", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_DEGREE, "The maximal degree used for the final polynomial.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_COEFFICIENT, "The minimum number used for the coefficients and the offset.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -100.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX_COEFFICIENT, "The maximum number used for the coefficients and the offset.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 100.0);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    private static class RegressionOptimization
    extends ESOptimization {
        private int replicationFactor;
        private ExampleSet exampleSet;
        private Attribute label;

        public RegressionOptimization(ExampleSet exampleSet, int replicationFactor, int maxIterations, int maxDegree, double minCoefficient, double maxCoefficient, RandomGenerator random, LoggingHandler logging) {
            super(RegressionOptimization.getMinVector(exampleSet, replicationFactor, minCoefficient), RegressionOptimization.getMaxVector(exampleSet, replicationFactor, maxDegree, maxCoefficient), 1, exampleSet.getAttributes().size() * 2 * replicationFactor + 1, 0, maxIterations, maxIterations, 6, 1.0, true, 1, 0.01, 0.0, false, false, random, logging);
            this.replicationFactor = replicationFactor;
            this.exampleSet = exampleSet;
            this.label = exampleSet.getAttributes().getLabel();
            int index = 0;
            for (int a = 0; a < exampleSet.getAttributes().size(); ++a) {
                for (int f = 0; f < replicationFactor; ++f) {
                    this.setValueType(index++, OptimizationValueType.VALUE_TYPE_DOUBLE);
                    this.setValueType(index++, OptimizationValueType.VALUE_TYPE_INT);
                }
            }
            this.setValueType(exampleSet.getAttributes().size() * replicationFactor * 2, OptimizationValueType.VALUE_TYPE_DOUBLE);
        }

        private static double[] getMinVector(ExampleSet exampleSet, int replicationFactor, double minCoefficient) {
            double[] result = new double[exampleSet.getAttributes().size() * replicationFactor * 2 + 1];
            int index = 0;
            for (int a = 0; a < exampleSet.getAttributes().size(); ++a) {
                for (int f = 0; f < replicationFactor; ++f) {
                    result[index++] = minCoefficient;
                    result[index++] = 1.0;
                }
            }
            result[result.length - 1] = minCoefficient;
            return result;
        }

        private static double[] getMaxVector(ExampleSet exampleSet, int replicationFactor, double maxDegree, double maxCoefficient) {
            double[] result = new double[exampleSet.getAttributes().size() * replicationFactor * 2 + 1];
            int index = 0;
            for (int a = 0; a < exampleSet.getAttributes().size(); ++a) {
                for (int f = 0; f < replicationFactor; ++f) {
                    result[index++] = maxCoefficient;
                    result[index++] = maxDegree;
                }
            }
            result[result.length - 1] = maxCoefficient;
            return result;
        }

        @Override
        public PerformanceVector evaluateIndividual(Individual individual) throws OperatorException {
            double[] values = individual.getValues();
            double[][] coefficients = this.getCoefficients(values);
            double[][] degrees = this.getDegrees(values);
            double offset = this.getOffset(values);
            double error = 0.0;
            for (Example example : this.exampleSet) {
                double prediction = PolynomialRegressionModel.calculatePrediction(example, coefficients, degrees, offset);
                double diff = Math.abs(example.getValue(this.label) - prediction);
                error += diff * diff;
            }
            error = Math.sqrt(error);
            PerformanceVector performanceVector = new PerformanceVector();
            performanceVector.addCriterion(new EstimatedPerformance("Polynomial Regression Error", error, 1, true));
            return performanceVector;
        }

        public double[][] getCoefficients(double[] values) {
            int attSize = this.exampleSet.getAttributes().size();
            double[][] coefficients = new double[this.replicationFactor][attSize];
            for (int f = 0; f < this.replicationFactor; ++f) {
                for (int a = 0; a < attSize; ++a) {
                    coefficients[f][a] = values[f * attSize * 2 + a * 2];
                }
            }
            return coefficients;
        }

        public double[][] getDegrees(double[] values) {
            int attSize = this.exampleSet.getAttributes().size();
            double[][] degrees = new double[this.replicationFactor][attSize];
            for (int f = 0; f < this.replicationFactor; ++f) {
                for (int a = 0; a < attSize; ++a) {
                    degrees[f][a] = values[f * attSize * 2 + a * 2 + 1];
                }
            }
            return degrees;
        }

        public double getOffset(double[] values) {
            return values[values.length - 1];
        }
    }
}

