/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.HyperplaneModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.kernels.DotKernel;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.List;

public class Perceptron
extends AbstractLearner {
    public static final String PARAMETER_ROUNDS = "rounds";
    public static final String PARAMETER_LEARNING_RATE = "learning_rate";

    public Perceptron(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Kernel kernel = this.getKernel();
        kernel.init(exampleSet);
        double initLearnRate = this.getParameterAsDouble(PARAMETER_LEARNING_RATE);
        NominalMapping labelMapping = exampleSet.getAttributes().getLabel().getMapping();
        String classNeg = labelMapping.getNegativeString();
        String classPos = labelMapping.getPositiveString();
        double classValueNeg = labelMapping.getNegativeIndex();
        int numberOfAttributes = exampleSet.getAttributes().size();
        HyperplaneModel model = new HyperplaneModel(exampleSet, classNeg, classPos, kernel);
        model.init(new double[numberOfAttributes], 0.0);
        for (int round = 0; round <= this.getParameterAsInt(PARAMETER_ROUNDS); ++round) {
            double learnRate = this.getLearnRate(round, this.getParameterAsInt(PARAMETER_ROUNDS), initLearnRate);
            Attributes attributes = exampleSet.getAttributes();
            for (Example example : exampleSet) {
                double prediction = model.predict(example);
                if (prediction == example.getLabel()) continue;
                double direction = example.getLabel() == classValueNeg ? -1.0 : 1.0;
                model.setIntercept(model.getIntercept() + learnRate * direction);
                double[] coefficients = model.getCoefficients();
                int i = 0;
                for (Attribute attribute : attributes) {
                    int n = i++;
                    coefficients[n] = coefficients[n] + learnRate * direction * example.getValue(attribute);
                }
            }
        }
        return model;
    }

    protected Kernel getKernel() throws UndefinedParameterError {
        return new DotKernel();
    }

    public double getLearnRate(int time, int maxtime, double initLearnRate) {
        return initLearnRate * Math.pow(initLearnRate * 0.1 / initLearnRate, (double)time / (double)maxtime);
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return HyperplaneModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return lc == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_ROUNDS, "The number of datascans used to adapt the hyperplane.", 0, Integer.MAX_VALUE, 3, false));
        types.add(new ParameterTypeDouble(PARAMETER_LEARNING_RATE, "The hyperplane will adapt with this rate to each example.", 0.0, 1.0, 0.05, false));
        return types;
    }
}

